/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.document.common.CommonDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.text.ITextDocument;
import de.intarsys.document.type.text.Text;
import de.intarsys.document.type.xml.XMLDocumentType;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import org.w3c.dom.Document;

public class XMLDocument
extends CommonDocument<Document>
implements ITextDocument<Document> {
    private String schemaName;
    private Document w3cDocument;
    private Text text;

    protected XMLDocument(IDocumentType type, ILocator locator, Document w3cDocument, String schemaAlias) {
        super(type, locator, null);
        this.w3cDocument = w3cDocument;
        this.schemaName = schemaAlias;
    }

    public Document getImpl() {
        return this.getW3CDocument();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Text getText() {
        if (this.text == null) {
            try {
                this.text = Text.createFromLocator((ILocator)this.getLocator());
            }
            catch (IOException e) {
                throw new TunnelingException((Throwable)e);
            }
        }
        return this.text;
    }

    public Document getW3CDocument() {
        return this.w3cDocument;
    }

    public void reparseFromLocator() throws IOException {
        XMLDocument reloaded = ((XMLDocumentType)this.getType()).basicCreateFromLocator(this.getLocator(), (IArgs)Args.create());
        this.text = null;
        this.w3cDocument = reloaded.w3cDocument;
        this.triggerChangedAll();
    }

    protected void replaceW3cDocument(Document w3cDocument, String schemaAlias) {
        this.w3cDocument = w3cDocument;
        this.schemaName = schemaAlias;
    }

    public void setLocator(ILocator locator) {
        super.setLocator(locator);
    }
}

