/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.document.type.xml.XMLEnvironment;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.locator.ILocator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;

public class XMLDocumentTools {
    public static Document createW3cDocument(ILocator locator) throws IOException {
        return XMLDocumentTools.createW3cDocument(locator, locator.getParent());
    }

    public static Document createW3cDocument(final ILocator locator, final ILocator base) throws IOException {
        try {
            DocumentBuilderFactory docBuilderFactory = DOMTools.createSecureDocumentBuilderFactory();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver2(){

                @Override
                public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                    return null;
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return this.resolveEntity(null, publicId, null, systemId);
                }

                @Override
                public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                    ILocator tmpLocator = XMLEnvironment.get().lookupEntity(publicId);
                    if (tmpLocator != null) {
                        return new InputSource(tmpLocator.getInputStream());
                    }
                    try {
                        URL systemUrl = new URL(systemId);
                        return new InputSource(systemUrl.toString());
                    }
                    catch (Exception e) {
                        File file = new File(systemId);
                        if (file.isAbsolute()) {
                            return new InputSource(systemId);
                        }
                        if (base != null) {
                            ILocator temp = base.getChild(systemId);
                            return new InputSource(temp.getInputStream());
                        }
                        if (locator.getParent() != null) {
                            ILocator temp = locator.getParent().getChild(systemId);
                            return new InputSource(temp.getInputStream());
                        }
                        return null;
                    }
                }
            });
            InputSource source = new InputSource(locator.getReader());
            Document resultDoc = docBuilder.parse(source);
            return resultDoc;
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXParseException e) {
            throw new IOException(e.getMessage() + " at line " + e.getLineNumber() + ", column " + e.getColumnNumber(), e);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private XMLDocumentTools() {
    }
}

