/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.document.common.CommonDocumentType;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.document.type.xml.ISchemaSetDocumentType;
import de.intarsys.document.type.xml.PACKAGE;
import de.intarsys.document.type.xml.SchemaSet;
import de.intarsys.document.type.xml.XMLDocument;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.dom.LoggingErrorHandler;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XMLDocumentType
extends CommonDocumentType<XMLDocument, Document>
implements ISchemaSetDocumentType {
    private static final Logger Log = LoggerFactory.getLogger(XMLDocumentType.class);
    public static final String ID = XMLDocumentType.class.getName();
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ARG_SCHEMA_NAME = "schemaName";
    private final Map<String, SchemaSet> schemaSets;
    private final Map<String, DocumentBuilderFactory> documentBuilderFactories;
    private final SchemaFactory schemaFactory;
    private final Object lock = new Object();

    public XMLDocumentType() {
        this.documentBuilderFactories = new HashMap<String, DocumentBuilderFactory>(5);
        this.schemaSets = new HashMap<String, SchemaSet>(5);
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchemaSet(SchemaSet schemaSet) {
        Object object = this.lock;
        synchronized (object) {
            this.schemaSets.put(schemaSet.getName(), schemaSet);
        }
    }

    protected XMLDocument basicCreateFromImpl(ILocator locator, Object impl) {
        if (locator == null) {
            locator = this.createLocator(null);
        }
        if (impl instanceof Document) {
            return new XMLDocument((IDocumentType)this, locator, (Document)impl, "");
        }
        return null;
    }

    protected XMLDocument basicCreateFromLocator(ILocator locator, IArgs args) throws IOException {
        DocumentBuilder documentBuilder = this.getDocumentBuilder(args);
        Document w3cDocument = this.parseDocument(locator, documentBuilder);
        return new XMLDocument((IDocumentType)this, locator, w3cDocument, this.getSchemaName(args));
    }

    protected XMLDocument basicCreateNew(IArgs args) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this.getDocumentBuilder(args);
        }
        catch (IOException e) {
            String msg = "error creating a new XML document with the given arguments";
            Log.error(msg, (Throwable)e);
            return null;
        }
        Document w3cDocument = documentBuilder.newDocument();
        return new XMLDocument((IDocumentType)this, (ILocator)new TransientLocator("new XMLDocument", this.getDefaultDefaultExtension()), w3cDocument, this.getSchemaName(args));
    }

    private DocumentBuilderFactory createDocumentBuilderFactory(Schema schema) {
        DocumentBuilderFactory factory = DOMTools.createSecureDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        factory.setSchema(schema);
        return factory;
    }

    public XMLDocument createFromLocator(ILocator locator, IArgs args) throws IOException {
        XMLDocument idoc = (XMLDocument)this.lookupDocument(locator);
        if (idoc != null) {
            String schemaName = this.getSchemaName(args);
            if (!idoc.getSchemaName().equals(schemaName)) {
                DocumentBuilder documentBuilder = this.getDocumentBuilder(args);
                Document w3cDocument = this.parseDocument(locator, documentBuilder);
                idoc.replaceW3cDocument(w3cDocument, schemaName);
            }
        }
        return (XMLDocument)super.createFromLocator(locator, args);
    }

    protected String getBaseName(Object impl) {
        return Msg.getString("XMLDocumentType.BaseName", new Object[0]);
    }

    protected String getBaseType(Object impl) {
        return Msg.getString("XMLDocumentType.BaseType", new Object[0]);
    }

    protected String getDefaultDefaultExtension() {
        return "xml";
    }

    protected String getDefaultDefaultMimeType() {
        return "application/xml";
    }

    protected DocumentBuilder getDocumentBuilder(IArgs args) throws IOException {
        DocumentBuilderFactory factory = this.getDocumentBuilderFactory(args);
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler((ErrorHandler)new LoggingErrorHandler(Log));
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    private DocumentBuilderFactory getDocumentBuilderFactory(IArgs args) throws IOException {
        String schemaName = this.getSchemaName(args);
        DocumentBuilderFactory factory = this.documentBuilderFactories.get(schemaName);
        if (factory == null) {
            Schema schema = this.loadSchemata(schemaName);
            factory = this.createDocumentBuilderFactory(schema);
            this.documentBuilderFactories.put(schemaName, factory);
        }
        return factory;
    }

    public String getLabel() {
        return Msg.getString("XMLDocumentType.BaseLabel", new Object[0]);
    }

    protected String getSchemaName(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)ARG_SCHEMA_NAME, (String)"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchemaSet getSchemaSet(String schemaSetName) {
        Object object = this.lock;
        synchronized (object) {
            return this.schemaSets.get(schemaSetName);
        }
    }

    private Schema loadSchemata(String schemaSetName) throws IOException {
        SchemaSet schemaSet = this.getSchemaSet(schemaSetName);
        if (schemaSet == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.schemaFactory.setResourceResolver(schemaSet);
                return this.schemaFactory.newSchema(schemaSet.getSources());
            }
            catch (SAXException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
    }

    protected Document parseDocument(ILocator locator, DocumentBuilder documentBuilder) throws IOException {
        InputStream in = locator.getInputStream();
        try {
            Document document = documentBuilder.parse(in);
            return document;
        }
        catch (SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        finally {
            StreamTools.close((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSchemaSet(String schemaSetName) {
        Object object = this.lock;
        synchronized (object) {
            this.schemaSets.remove(schemaSetName);
            this.documentBuilderFactories.remove(schemaSetName);
        }
    }
}

