/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.type.xml;

import de.intarsys.document.common.CommonSaveFunctor;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.type.xml.XMLDocument;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.FunctorExecutionException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.xml.TransformerTools;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class XMLSaveFunctor
extends CommonSaveFunctor {
    protected Object basicSave(IDocument document, ILocator locator, IArgs args) throws FunctorException {
        if (locator == null) {
            locator = document.getLocator();
        } else {
            ((XMLDocument)document).setLocator(locator);
        }
        Document xmlDocument = (Document)document.getImpl();
        try (OutputStream out = this.getOutputStream(locator);){
            TransformerTools.createSecureTransformerFactory().newTransformer().transform(new DOMSource(xmlDocument), new StreamResult(out));
        }
        catch (IOException | TransformerException e) {
            throw new FunctorExecutionException((Throwable)e);
        }
        ((XMLDocument)document).setLocator(locator);
        try {
            ((XMLDocument)document).reparseFromLocator();
        }
        catch (IOException e) {
            throw new FunctorExecutionException((Throwable)e);
        }
        return document;
    }

    private OutputStream getOutputStream(ILocator locator) throws FunctorException {
        try {
            return new IgnoreFlushOutputStream(locator.getOutputStream());
        }
        catch (IOException e) {
            throw new FunctorExecutionException((Throwable)e);
        }
    }

    private static class IgnoreFlushOutputStream
    extends OutputStream {
        private final OutputStream wrapped;

        public IgnoreFlushOutputStream(OutputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.flush();
            this.wrapped.close();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.wrapped.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.wrapped.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.wrapped.write(b);
        }
    }
}

