/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.app.signature;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.signature.CommonBatchSigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.csc.app.signature.CscPrincipal;
import de.intarsys.security.device.csc.app.signature.CscSignerException;
import de.intarsys.security.device.csc.auth.AuthorizationManager;
import de.intarsys.security.device.csc.auth.Credential;
import de.intarsys.security.device.csc.auth.CredentialSelector;
import de.intarsys.security.device.csc.client.CscClient;
import de.intarsys.security.device.csc.client.CscException;
import de.intarsys.security.device.csc.client.impl.v1.CredentialInfoResponse;
import de.intarsys.security.device.csc.device.CscDevice;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigestSupport;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CscSigner
extends CommonBatchSigner {
    private static final List<String> SUPPORTED_HASH_ALGORITHM_NAMES = List.of("SHA-256", "SHA-384", "SHA-512", "RIPEMD256");
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AuthorizationManager authorizationManager;
    private CscClient cscClient;
    private String userId;
    private CredentialSelector credentialSelector;
    private Credential credential;

    public CscSigner(CscDevice device, CscClient cscClient, AuthorizationManager authorizationManager, String userId, CredentialSelector credentialSelector) {
        super((CommonDevice)device);
        this.cscClient = cscClient;
        this.authorizationManager = authorizationManager;
        this.userId = userId;
        this.credentialSelector = credentialSelector;
    }

    public String getEncryptionAlgorithmName() {
        IX509PublicKeyCertificate certificate = this.getCertificate();
        return certificate == null ? null : certificate.getPublicKey().getAlgorithm();
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_HASH_ALGORITHM_NAMES;
    }

    public boolean isBasic() {
        return true;
    }

    protected IConversation<Void> basicSignPrepare() {
        return this.authorizeService().thenAccept(this::selectCredential);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void selectCredential(Map<String, Object> headers) throws CscSignerException {
        try {
            List<String> credentialIds = this.cscClient.getCredentialIds(this.userId, headers);
            for (String id : credentialIds) {
                CredentialInfoResponse info = this.cscClient.getCredentialInfo(id, headers);
                try {
                    Credential candidate = Credential.from(id, info);
                    if (!this.credentialSelector.matches(candidate)) continue;
                    this.credential = candidate;
                    this.setCertificatePath(this.credential.getCertificatePath());
                    this.logger.debug("Selected credential {}", (Object)this.credential);
                    return;
                }
                catch (IllegalArgumentException exception) {
                    throw new CscSignerException("Invalid credential " + id, exception);
                    throw new CscSignerException("No credential available that matches " + this.credentialSelector);
                }
            }
        }
        catch (CscException exception) {
            throw new CscSignerException("Failed to query credentials", exception);
        }
    }

    protected IConversation<Void> basicSignAuthorized() {
        List<IDigest> digests = this.getDigestsToBeSigned();
        if (digests.isEmpty()) {
            return Conversation.completed(null);
        }
        try {
            if (digests.size() > this.credential.getMultisign()) {
                throw new CscSignerException(String.format("Number of hashes to be signed (%d) exceeds the credential's limit for a single authorization request (%d)", digests.size(), this.credential.getMultisign()));
            }
            DigestAlgorithm digestAlgorithm = this.determineDigestAlgorithm(digests);
            SignatureAlgorithm signatureAlgorithm = this.determineSignatureAlgorithm(digestAlgorithm);
            this.logger.debug("Signing {} {} hashes with {}", new Object[]{digests.size(), digestAlgorithm, signatureAlgorithm});
            byte[] signatureAlgorithmParameters = this.determineAlgorithmParameters(signatureAlgorithm, digestAlgorithm);
            List<byte[]> hashes = this.toHashes(digests);
            return this.authorizeSignature(hashes).thenCompose(sad -> this.sign(digestAlgorithm, hashes, signatureAlgorithm, signatureAlgorithmParameters, (AccessToken)sad)).thenAccept(x$0 -> this.tasksComplete((List)x$0));
        }
        catch (CscSignerException exception) {
            return Conversation.failed((Throwable)((Object)exception));
        }
    }

    private List<IDigest> getDigestsToBeSigned() {
        return this.getTasks().stream().map(task -> task.toBeSignedData).map(IDigestSupport::getDigest).toList();
    }

    private DigestAlgorithm determineDigestAlgorithm(Collection<IDigest> digests) throws CscSignerException {
        List<String> algorithmNames = digests.stream().map(IDigest::getAlgorithmName).distinct().toList();
        if (algorithmNames.size() != 1) {
            throw new CscSignerException("Cannot sign hashes with different algorithms in the same operation");
        }
        String algorithmName = algorithmNames.get(0);
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithm((String)algorithmName);
        if (algorithm == null) {
            throw new CscSignerException("Unknown hash algorithm " + algorithmName);
        }
        return algorithm;
    }

    private SignatureAlgorithm determineSignatureAlgorithm(DigestAlgorithm digestAlgorithm) throws CscSignerException {
        for (SignatureAlgorithm signatureAlgorithm : this.credential.getSupportedSignatureAlgorithms()) {
            DigestAlgorithm implicitDigestAlgorithm = signatureAlgorithm.getDigestAlgorithm();
            if (implicitDigestAlgorithm != null && !implicitDigestAlgorithm.equals((Object)digestAlgorithm)) continue;
            return signatureAlgorithm;
        }
        throw new CscSignerException(String.format("Hash algorithm %s is not supported by credential %s", digestAlgorithm, this.credential));
    }

    private byte[] determineAlgorithmParameters(SignatureAlgorithm signatureAlgorithm, DigestAlgorithm digestAlgorithm) throws CscSignerException {
        if (SignatureAlgorithm.ALG_RSASSA_PSS.equals((Object)signatureAlgorithm)) {
            return this.encodeParameters("RSASSA-PSS", PSSEncoding.createPSSParameterSpec((DigestAlgorithm)digestAlgorithm));
        }
        if (SignatureAlgorithm.ALG_RSAES_OAEP.equals((Object)signatureAlgorithm)) {
            return this.encodeParameters("OAEP", new OAEPParameterSpec(digestAlgorithm.getName(), "MGF1", new MGF1ParameterSpec(digestAlgorithm.getName()), PSource.PSpecified.DEFAULT));
        }
        return null;
    }

    private byte[] encodeParameters(String algorithmName, AlgorithmParameterSpec parameterSpec) throws CscSignerException {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance(algorithmName);
            parameters.init(parameterSpec);
            return parameters.getEncoded();
        }
        catch (IOException | NoSuchAlgorithmException | InvalidParameterSpecException exception) {
            throw new CscSignerException("Failed to encoded parameters for algorithm " + algorithmName);
        }
    }

    private List<byte[]> toHashes(Collection<IDigest> digests) {
        return digests.stream().map(IDigest::getBytes).toList();
    }

    private IConversation<Map<String, Object>> authorizeService() {
        return this.authorizationManager.authorizeService().thenApply(accessToken -> accessToken == null ? Map.of() : Map.of("Authorization", accessToken.toAuthorizationHeader()));
    }

    private IConversation<List<ISignatureData>> sign(DigestAlgorithm digestAlgorithm, List<byte[]> hashes, SignatureAlgorithm signatureAlgorithm, byte[] signatureAlgorithmParameters, AccessToken sad) {
        return this.authorizeService().thenApply(headers -> this.cscClient.sign(this.credential.getId(), digestAlgorithm.getOid(), hashes, signatureAlgorithm.getOid(), signatureAlgorithmParameters, sad.getValue(), (Map<String, Object>)headers)).thenApply(this::boxSignatures);
    }

    private List<ISignatureData> boxSignatures(List<byte[]> signatures) {
        return signatures.stream().map(SignatureData::create).toList();
    }

    private IConversation<AccessToken> authorizeSignature(List<byte[]> hashes) {
        return this.authorizationManager.authorizeSignature(this.credential.getId(), hashes);
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return new CscPrincipal(this.getDevice(), certificate);
    }

    public void buildCertificatePath() {
    }
}

