/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.app.signature;

import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.csc.app.signature.CscSigner;
import de.intarsys.security.device.csc.auth.AnyCredentialSelector;
import de.intarsys.security.device.csc.auth.AuthorizationManager;
import de.intarsys.security.device.csc.auth.CredentialCertificateSelector;
import de.intarsys.security.device.csc.auth.CredentialIdSelector;
import de.intarsys.security.device.csc.auth.CredentialSelector;
import de.intarsys.security.device.csc.device.CscDevice;
import de.intarsys.security.device.csc.util.MoreArgTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class CscSignerFactory
extends CommonSignerFactory<CscDevice, CscSigner> {
    public static final String ARG_USER_ID = "userId";
    public static final String ARG_CREDENTIAL_ID = "credentialId";
    public static final String ARG_CREDENTIAL_SELECTOR = "credentialSelector";
    public static final String ARG_CERTIFICATE_FILTER = "certificateFilter";
    public static final String ARG_AUTHORIZATION_MANAGER = "authorizationManager";

    public Class<CscSigner> getResultType() {
        return CscSigner.class;
    }

    protected CscSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        CscDevice device = (CscDevice)this.getDevice(args);
        String userId = ArgTools.getString((IArgs)args, (String)ARG_USER_ID, null);
        CredentialSelector credentialSelector = this.getCredentialSelector(args);
        AuthorizationManager authorizationManager = MoreArgTools.createInstance(args, ARG_AUTHORIZATION_MANAGER, AuthorizationManager.class);
        if (authorizationManager == null && (authorizationManager = device.getAuthorizationManager()) == null) {
            throw new IllegalArgumentException(String.format("Argument %s required; device has no default authorization manager", ARG_AUTHORIZATION_MANAGER));
        }
        return new CscSigner(device, device.getCscClient(), authorizationManager, userId, credentialSelector);
    }

    private CredentialSelector getCredentialSelector(IArgs args) throws ObjectCreationException {
        String credentialId = ArgTools.getString((IArgs)args, (String)ARG_CREDENTIAL_ID, null);
        if (credentialId != null) {
            return new CredentialIdSelector(credentialId);
        }
        Object certificateFilterArg = ArgTools.getObject((IArgs)args, (String)ARG_CERTIFICATE_FILTER, null);
        if (certificateFilterArg != null) {
            IX509CertificateFilter certificateFilter = CertificateFilterTools.createCertificateFilter((Object)certificateFilterArg);
            return new CredentialCertificateSelector(certificateFilter);
        }
        CredentialSelector selector = MoreArgTools.createInstance(args, ARG_CREDENTIAL_SELECTOR, CredentialSelector.class);
        if (selector != null) {
            return selector;
        }
        return new AnyCredentialSelector();
    }

    protected String getArgNamePassword() {
        throw new UnsupportedOperationException("Why do we need this?");
    }
}

