/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.auth;

import de.intarsys.security.device.csc.auth.AccountTokenSupplier;
import de.intarsys.security.device.csc.auth.AuthorizationManager;
import de.intarsys.security.device.csc.auth.OAuth2AuthorizationManager;
import de.intarsys.security.device.csc.util.MoreArgTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.net.URI;
import java.time.Duration;

public class AuthorizationManagerFactory
extends CommonInstantiatingFactory<AuthorizationManager> {
    public static final String ARG_CLIENT_ID = "clientId";
    public static final String ARG_CLIENT_SECRET = "clientSecret";
    public static final String ARG_ACCOUNT_TOKEN_SUPPLIER = "accountTokenSupplier";
    public static final String ARG_ACCESS_TOKEN_LIFETIME_MARGIN = "accessTokenLifetimeMargin";
    public static final String ARG_CALLBACK_URI = "callbackUri";
    public static final String ARG_OAUTH2_BASE_URI = "oauth2BaseUri";

    public Class<? extends AuthorizationManager> getResultType() {
        return AuthorizationManager.class;
    }

    protected AuthorizationManager basicCreateInstance(IArgs args) throws ObjectCreationException {
        String clientId = ArgTools.getString((IArgs)args, (String)ARG_CLIENT_ID, null);
        Secret clientSecret = ArgTools.getSecretHide((IArgs)args, (String)ARG_CLIENT_SECRET, null);
        String oauth2BaseUri = ArgTools.getString((IArgs)args, (String)ARG_OAUTH2_BASE_URI, null);
        String callbackUri = ArgTools.getString((IArgs)args, (String)ARG_CALLBACK_URI, null);
        Duration lifetimeMargin = (Duration)ArgTools.getValue((IArgs)args, (String)ARG_ACCESS_TOKEN_LIFETIME_MARGIN, Duration.class, (Object)OAuth2AuthorizationManager.DEFAULT_ACCESS_TOKEN_LIFETIME_MARGIN);
        AccountTokenSupplier accountTokenSupplier = MoreArgTools.createInstance(args, ARG_ACCOUNT_TOKEN_SUPPLIER, AccountTokenSupplier.class);
        OAuth2AuthorizationManager manager = new OAuth2AuthorizationManager();
        manager.setClientId(clientId);
        manager.setClientSecret(clientSecret);
        manager.setAccountTokenSupplier(accountTokenSupplier);
        manager.setAccessTokenLifetimeMargin(lifetimeMargin);
        manager.setOauth2BaseUri(URI.create(oauth2BaseUri));
        if (callbackUri != null && !callbackUri.isEmpty()) {
            manager.setCallbackUri(URI.create(callbackUri));
        }
        return manager;
    }
}

