/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.auth;

import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.device.csc.client.impl.v1.CertificateInfo;
import de.intarsys.security.device.csc.client.impl.v1.CredentialInfoResponse;
import de.intarsys.security.device.csc.client.impl.v1.KeyInfo;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;

public class Credential {
    private String id;
    private String description;
    private List<IX509PublicKeyCertificate> certificatePath;
    private List<SignatureAlgorithm> supportedSignatureAlgorithms;
    private int multisign;

    public static Credential from(String id, CredentialInfoResponse info) {
        CertificateInfo certificateInfo = info.certificate();
        if (certificateInfo == null) {
            throw new IllegalArgumentException("Missing certificate information");
        }
        List<byte[]> certificates = certificateInfo.certificates();
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("Missing certificates");
        }
        ArrayList<IX509PublicKeyCertificate> certificatePath = new ArrayList<IX509PublicKeyCertificate>();
        for (byte[] certificate : certificates) {
            try {
                certificatePath.add(X509CertificateFactory.get().createPublicKeyCertificate(certificate));
            }
            catch (CertificateException exception) {
                throw new IllegalArgumentException("Invalid certificate", exception);
            }
        }
        KeyInfo keyInfo = info.key();
        if (keyInfo == null) {
            throw new IllegalArgumentException("Missing key information");
        }
        List<String> supportedAlgorithmOids = keyInfo.supportedAlgorithmOids();
        if (supportedAlgorithmOids == null) {
            throw new IllegalArgumentException("Missing supported signature algorithms");
        }
        ArrayList<SignatureAlgorithm> supportedAlgorithms = new ArrayList<SignatureAlgorithm>();
        for (String oid : supportedAlgorithmOids) {
            SignatureAlgorithm algorithm = SignatureAlgorithm.lookupAlgorithm((String)oid);
            if (algorithm == null) {
                throw new IllegalArgumentException("Unknown signature algorithm OID: " + oid);
            }
            supportedAlgorithms.add(algorithm);
        }
        int multisign = info.multisign() == null ? 1 : info.multisign();
        return new Credential(id, info.description(), certificatePath, supportedAlgorithms, multisign);
    }

    public Credential(String id, String description, List<IX509PublicKeyCertificate> certificatePath, List<SignatureAlgorithm> supportedSignatureAlgorithms, int multisign) {
        this.id = id;
        this.description = description;
        this.certificatePath = certificatePath;
        this.supportedSignatureAlgorithms = supportedSignatureAlgorithms;
        this.multisign = multisign;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificatePath.get(0);
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return (IX509PublicKeyCertificate[])this.certificatePath.toArray(IX509PublicKeyCertificate[]::new);
    }

    public List<SignatureAlgorithm> getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public int getMultisign() {
        return this.multisign;
    }

    public String toString() {
        return String.format("%s (description=%s, subject='%s')", this.id, this.description, this.getCertificate().getSubjectX500Principal());
    }
}

