/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.auth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import de.intarsys.security.device.csc.auth.AccountTokenSupplier;
import de.intarsys.tools.crypto.Secret;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

public class DefaultAccountTokenSupplier
implements AccountTokenSupplier {
    public static final Duration DEFAULT_TOKEN_LIFETIME = Duration.ofHours(1L);
    private Duration tokenLifetime = DEFAULT_TOKEN_LIFETIME;
    private String issuer;
    private String subject;
    private String authorizedPresenter;
    private Secret clientSecret;

    public void setTokenLifetime(Duration tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setAuthorizedPresenter(String authorizedPresenter) {
        this.authorizedPresenter = authorizedPresenter;
    }

    public void setClientSecret(Secret clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Override
    public String getAccountToken() {
        Instant now = Instant.now();
        Instant expirationTime = now.plus(this.tokenLifetime);
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(this.issuer).subject(this.subject).claim("azp", (Object)this.authorizedPresenter).jwtID(UUID.randomUUID().toString()).issueTime(Date.from(now)).expirationTime(Date.from(expirationTime)).build();
        try {
            MACSigner signer = new MACSigner(this.sha256(this.clientSecret.getBytes()));
            SignedJWT signedJwt = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), claims);
            signedJwt.sign((JWSSigner)signer);
            return signedJwt.serialize();
        }
        catch (JOSEException | GeneralSecurityException exception) {
            throw new IllegalStateException("Failed to create account token", exception);
        }
    }

    private byte[] sha256(byte[] bytes) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            return sha256.digest(bytes);
        }
        catch (NoSuchAlgorithmException exception) {
            throw new RuntimeException("Should not happen, because SHA-256 is a standard algorithm", exception);
        }
    }

    public String toString() {
        return String.format("%s(authorizedPresenter=%s, issuer=%s, subject=%s, tokenLifetime=%s, clientSecret=%s)", this.getClass().getSimpleName(), this.authorizedPresenter, this.issuer, this.subject, this.tokenLifetime, this.clientSecret == null ? "none" : "?");
    }
}

