/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.auth;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.GeneralException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import de.intarsys.security.device.csc.auth.AccountTokenSupplier;
import de.intarsys.security.device.csc.auth.AuthorizationManager;
import de.intarsys.security.device.csc.oauth2.HttpRequestHandler;
import de.intarsys.security.device.csc.oauth2.TokenResponseParser;
import de.intarsys.security.device.csc.util.Conversations;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.jaxrs.RequestContext;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthorizationManager
implements AuthorizationManager {
    public static final Duration DEFAULT_ACCESS_TOKEN_LIFETIME_MARGIN = Duration.ofMinutes(1L);
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpRequestHandler httpRequestHandler = new HttpRequestHandler(this.logger);
    private URI oauth2BaseUri;
    private ClientID clientId;
    private Secret clientSecret;
    private AccountTokenSupplier accountTokenSupplier;
    private Duration accessTokenLifetimeMargin = DEFAULT_ACCESS_TOKEN_LIFETIME_MARGIN;
    private URI callbackUri;
    private Object lock = new Object();
    private Instant accessTokenExpirationTime;
    private AccessToken accessToken;
    private RefreshToken refreshToken;
    private IConversation<AccessToken> serviceAuthorizationConversation;

    public void setOauth2BaseUri(URI oauth2BaseUri) {
        this.oauth2BaseUri = oauth2BaseUri;
    }

    public void setClientId(String clientId) {
        this.clientId = new ClientID(clientId);
    }

    public void setClientSecret(Secret clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setAccountTokenSupplier(AccountTokenSupplier accountTokenSupplier) {
        this.accountTokenSupplier = accountTokenSupplier;
    }

    public void setAccessTokenLifetimeMargin(Duration accessTokenLifetimeMargin) {
        this.accessTokenLifetimeMargin = accessTokenLifetimeMargin;
    }

    public void setCallbackUri(URI callbackUri) {
        this.callbackUri = callbackUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConversation<AccessToken> authorizeService() {
        Object object = this.lock;
        synchronized (object) {
            if (this.accessToken != null && this.accessTokenExpirationTime.isAfter(Instant.now())) {
                this.logger.trace("Access token is still valid");
                return Conversation.completed((Object)this.accessToken);
            }
            this.accessToken = null;
            this.accessTokenExpirationTime = Instant.MIN;
            if (this.refreshToken != null) {
                try {
                    this.logger.trace("Trying to refresh access token");
                    Tokens tokens = this.requestTokens((AuthorizationGrant)new RefreshTokenGrant(this.refreshToken));
                    this.logger.trace("Refreshed access token");
                    return Conversation.completed((Object)this.finishServiceAuthorization(tokens));
                }
                catch (GeneralException | IOException exception) {
                    this.logger.warn("Failed to refresh access token", exception);
                    this.refreshToken = null;
                }
            }
            if (this.serviceAuthorizationConversation == null || this.serviceAuthorizationConversation.isDone()) {
                this.serviceAuthorizationConversation = this.createServiceAuthorizationConversation();
            }
            return this.serviceAuthorizationConversation;
        }
    }

    private IConversation<AccessToken> createServiceAuthorizationConversation() {
        Conversation conversation = new Conversation("oauth2/authorize (service)");
        URI callbackUri = this.determineCallbackUri();
        URI endpointUri = this.oauth2BaseUri.resolve("oauth2/authorize");
        AuthorizationRequest.Builder requestBuilder = new AuthorizationRequest.Builder(ResponseType.CODE, this.clientId).endpointURI(endpointUri).scope(new Scope(new String[]{"service"})).redirectionURI(callbackUri).state(new State(conversation.getHandle()));
        String accountToken = this.getAccountToken();
        if (accountToken != null) {
            requestBuilder.customParameter("account_token", new String[]{accountToken});
        }
        AuthorizationRequest request = requestBuilder.build();
        this.redirect((IConversation<?>)conversation, request.toURI());
        return conversation.thenApply(authorizationResponse -> this.createAuthorizationGrant((AuthorizationResponse)authorizationResponse, callbackUri)).thenApply(this::requestTokens).thenApply(this::finishServiceAuthorization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessToken finishServiceAuthorization(Tokens tokens) {
        Object object = this.lock;
        synchronized (object) {
            this.accessToken = tokens.getAccessToken();
            this.accessTokenExpirationTime = this.accessToken == null ? Instant.MIN : Instant.now().plus(this.accessToken.getLifetime(), ChronoUnit.SECONDS).minus(this.accessTokenLifetimeMargin);
            this.refreshToken = tokens.getRefreshToken();
            return this.accessToken;
        }
    }

    @Override
    public IConversation<AccessToken> authorizeSignature(String credentialId, List<byte[]> hashes) {
        this.logger.debug("Authorizing signature: credentialId={}, #hashes={}", (Object)credentialId, (Object)hashes.size());
        Conversation conversation = new Conversation("oauth2/authorize (credential)");
        URI callbackUri = this.determineCallbackUri();
        URI endpointUri = this.oauth2BaseUri.resolve("oauth2/authorize");
        String[] stringArray = new String[1];
        stringArray[0] = hashes.stream().map(Base64.getEncoder()::encodeToString).collect(Collectors.joining(","));
        AuthorizationRequest.Builder requestBuilder = new AuthorizationRequest.Builder(ResponseType.CODE, this.clientId).endpointURI(endpointUri).scope(new Scope(new String[]{"credential"})).redirectionURI(callbackUri).customParameter("credentialId", new String[]{credentialId}).customParameter("numSignatures", new String[]{String.valueOf(hashes.size())}).customParameter("hash", stringArray).state(new State(conversation.getHandle()));
        String accountToken = this.getAccountToken();
        if (accountToken != null) {
            requestBuilder.customParameter("account_token", new String[]{accountToken});
        }
        AuthorizationRequest request = requestBuilder.build();
        this.redirect((IConversation<?>)conversation, request.toURI());
        return conversation.thenApply(authorizationResponse -> this.createAuthorizationGrant((AuthorizationResponse)authorizationResponse, callbackUri)).thenApply(this::requestTokens).thenApply(Tokens::getAccessToken);
    }

    private URI determineCallbackUri() {
        if (this.callbackUri != null) {
            return this.callbackUri;
        }
        return RequestContext.get().getUriBuilderContext().path("api/csc/callback").build(new Object[0]);
    }

    private AuthorizationGrant createAuthorizationGrant(AuthorizationResponse authorizationResponse, URI callbackUri) throws GeneralException {
        if (authorizationResponse.indicatesSuccess()) {
            AuthorizationCode code = authorizationResponse.toSuccessResponse().getAuthorizationCode();
            return new AuthorizationCodeGrant(code, callbackUri);
        }
        ErrorObject error = authorizationResponse.toErrorResponse().getErrorObject();
        throw new GeneralException(this.createMessage("Authorization failed", error), error);
    }

    private void redirect(IConversation<?> conversation, URI destination) {
        Conversations.setRedirection(conversation, destination);
        conversation.setReplyStage((IReplyStage)new HttpRedirectStage(destination, false, false));
        ConversationRegistry.publishForLifetime(conversation);
        this.logger.trace("Redirected conversation {} to {}", conversation, (Object)destination);
    }

    private String createMessage(String message, ErrorObject error) {
        String description;
        if (error == null) {
            return message;
        }
        String code = error.getCode();
        if (code == null || code.isEmpty()) {
            code = "unknown";
        }
        return (description = error.getDescription()) == null || description.isEmpty() ? String.format("%s (%s)", message, code) : String.format("%s: %s (%s)", message, description, code);
    }

    private Tokens requestTokens(AuthorizationGrant authorizationGrant) throws IOException, GeneralException {
        TokenResponse tokenResponse;
        ClientSecretPost clientAuthentication;
        this.logger.trace("Requesting token");
        URI endpointUri = this.oauth2BaseUri.resolve("oauth2/token");
        try {
            clientAuthentication = new ClientSecretPost(this.clientId, new com.nimbusds.oauth2.sdk.auth.Secret(this.clientSecret.getString()));
        }
        catch (GeneralSecurityException exception) {
            throw new GeneralException("Bad client secret", (Throwable)exception);
        }
        TokenRequest tokenRequest = new TokenRequest(endpointUri, (ClientAuthentication)clientAuthentication, authorizationGrant);
        try {
            tokenResponse = this.httpRequestHandler.send((Request)tokenRequest, TokenResponseParser::parse);
        }
        catch (ParseException exception) {
            throw new GeneralException("Invalid token response", (Throwable)exception);
        }
        if (tokenResponse.indicatesSuccess()) {
            return tokenResponse.toSuccessResponse().getTokens();
        }
        throw new GeneralException("Failed to obtain token", tokenResponse.toErrorResponse().getErrorObject());
    }

    private String getAccountToken() {
        return this.accountTokenSupplier == null ? null : this.accountTokenSupplier.getAccountToken();
    }

    public String toString() {
        return String.format("%s(oauth2Base=%s, clientId=%s, clientSecret=%s, accountToken=%s, accessTokenLifetimeMargin=%s, callback=%s)", this.getClass().getSimpleName(), this.oauth2BaseUri, this.clientId, this.clientSecret == null ? "none" : "?", this.accountTokenSupplier, this.accessTokenLifetimeMargin, this.callbackUri == null ? "autodetect" : this.callbackUri);
    }
}

