/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.client;

import de.intarsys.security.device.csc.client.CscException;
import de.intarsys.security.device.csc.client.impl.ErrorResponse;
import de.intarsys.security.device.csc.client.impl.v1.CertificatesOption;
import de.intarsys.security.device.csc.client.impl.v1.CredentialInfoRequest;
import de.intarsys.security.device.csc.client.impl.v1.CredentialInfoResponse;
import de.intarsys.security.device.csc.client.impl.v1.InfoRequest;
import de.intarsys.security.device.csc.client.impl.v1.InfoResponse;
import de.intarsys.security.device.csc.client.impl.v1.ListCredentialsRequest;
import de.intarsys.security.device.csc.client.impl.v1.ListCredentialsResponse;
import de.intarsys.security.device.csc.client.impl.v1.SignHashRequest;
import de.intarsys.security.device.csc.client.impl.v1.SignHashResponse;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CscClient {
    private static final int MAX_RESULTS = 100;
    private static final int MAX_RESULT_PAGES = 100;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebTarget api;

    public CscClient(WebTarget api) {
        this.api = api;
    }

    public InfoResponse getServiceInfo(Map<String, Object> headers) throws CscException {
        this.logger.trace("Requesting service info: headers={}", headers);
        InfoRequest request = new InfoRequest();
        return this.post("info", request, headers, InfoResponse.class);
    }

    public List<String> getCredentialIds(String userId, Map<String, Object> headers) throws CscException {
        this.logger.trace("Requesting credential IDs: userId={}, headers={}", (Object)userId, headers);
        ArrayList<String> credentialIds = new ArrayList<String>();
        ListCredentialsRequest request = new ListCredentialsRequest(userId, 100);
        int pageCount = 0;
        do {
            ListCredentialsResponse response = this.post("credentials/list", request, headers, ListCredentialsResponse.class);
            credentialIds.addAll(response.credentialIds());
            request = request.withPageToken(response.nextPageToken());
        } while (++pageCount < 100 && request.pageToken() != null);
        return credentialIds;
    }

    public CredentialInfoResponse getCredentialInfo(String credentialId, Map<String, Object> headers) throws CscException {
        this.logger.trace("Requesting credential infos: credentialId={}, headers={}", (Object)credentialId, headers);
        CredentialInfoRequest request = new CredentialInfoRequest(credentialId, CertificatesOption.CHAIN, true, true);
        return this.post("credentials/info", request, headers, CredentialInfoResponse.class);
    }

    public List<byte[]> sign(String credentialId, String hashAlgorithmOid, List<byte[]> hashes, String signatureAlgorithmOid, byte[] signatureAlgorithmParameters, String sad, Map<String, Object> headers) throws CscException {
        this.logger.trace("Creating signature: credentialId={}, hashAlgorithm={}, #hashes={}, signatureAlgorithm={}, signatureAlgorithmParameters={}, headers={}", new Object[]{credentialId, hashAlgorithmOid, hashes.size(), signatureAlgorithmOid, signatureAlgorithmParameters == null ? null : Base64.getEncoder().encodeToString(signatureAlgorithmParameters), headers});
        SignHashRequest request = new SignHashRequest(credentialId, sad, hashes, hashAlgorithmOid, signatureAlgorithmOid, signatureAlgorithmParameters);
        SignHashResponse response = this.post("signatures/signHash", request, headers, SignHashResponse.class);
        return response.signatures();
    }

    private <T> T post(String path, Object request, Map<String, Object> headers, Class<T> responseType) throws CscException {
        Invocation.Builder invocation = this.api.path(path).request();
        headers.forEach((arg_0, arg_1) -> ((Invocation.Builder)invocation).header(arg_0, arg_1));
        try {
            return (T)invocation.post(Entity.json((Object)request), responseType);
        }
        catch (WebApplicationException exception) {
            Response response = exception.getResponse();
            try {
                int httpStatus = response.getStatus();
                if (response.hasEntity()) {
                    try {
                        String description;
                        ErrorResponse errorResponse = (ErrorResponse)response.readEntity(ErrorResponse.class);
                        String error = errorResponse.error();
                        if (error == null) {
                            error = "<unknown>";
                        }
                        if ((description = errorResponse.errorDescription()) == null) {
                            description = "<no description>";
                        }
                        throw new CscException(String.format("%s: %s (HTTP status %d)", error, description, httpStatus), exception);
                    }
                    catch (ProcessingException processingException) {
                        // empty catch block
                    }
                }
                throw new CscException(String.format("Request failed (HTTP status %d)", httpStatus), exception);
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }
}

