/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.csc.auth.AuthorizationManager;
import de.intarsys.security.device.csc.client.CscClient;
import de.intarsys.security.device.csc.client.HttpConfiguration;
import de.intarsys.security.device.csc.device.CscDeviceProvider;
import de.intarsys.security.device.csc.util.MoreArgTools;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.ext.ContextResolver;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.logging.LoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FactoredBy(factory=CscDeviceProvider.class)
public class CscDevice
extends CommonDevice<CscDeviceProvider> {
    public static final String ARG_HTTP_CONFIGURATION = "httpConfiguration";
    public static final String ARG_API_BASE_URI = "apiBaseUri";
    public static final String ARG_AUTHORIZATION_MANAGER = "authorizationManager";
    static final String LIC_PRODUCT = "de.intarsys.security.device.csc";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpConfiguration httpConfiguration;
    private String apiBaseUri;
    private CscClient cscClient;
    private AuthorizationManager authorizationManager;

    protected CscDevice(CscDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public void configure(IArgs args) throws Exception {
        super.configure(args);
        this.httpConfiguration = HttpConfiguration.from(args, ARG_HTTP_CONFIGURATION);
        this.apiBaseUri = ArgTools.getString((IArgs)args, (String)ARG_API_BASE_URI, null);
        if (this.apiBaseUri == null) {
            throw ExceptionTools.argumentRequired((String)ARG_API_BASE_URI);
        }
        this.authorizationManager = MoreArgTools.createInstance(args, ARG_AUTHORIZATION_MANAGER, AuthorizationManager.class);
    }

    private Client createClient(HttpConfiguration configuration) {
        SSLContext sslContext;
        HostnameVerifier hostnameVerifier;
        LoggingFeature logging = new LoggingFeature(java.util.logging.Logger.getLogger(((Object)((Object)this)).getClass().getName()), Level.INFO, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(8192));
        ContextResolver<ObjectMapper> objectMapperProvider = new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            }
        };
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)new ClientConfig().register((Object)logging).register((Object)objectMapperProvider).register(JacksonJsonProvider.class)).connectTimeout(configuration.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(configuration.getReadTimeout(), TimeUnit.MILLISECONDS);
        if (configuration.isUseProxy()) {
            String proxyHost = System.getProperty("http.proxyHost");
            if (proxyHost == null) {
                this.logger.error("Proxy enabled, but system property http.proxyHost is not set; continuing without proxy");
            } else {
                String proxyScheme = proxyHost.startsWith("http") ? "" : "http://";
                String proxyPort = System.getProperty("http.proxyPort");
                String proxyUri = proxyPort == null ? proxyScheme + proxyHost : proxyScheme + proxyHost + ":" + proxyPort;
                String proxyUser = System.getProperty("http.proxyUser");
                String proxyPassword = System.getProperty("http.proxyPassword");
                ((ClientBuilder)((ClientBuilder)((ClientBuilder)builder.property("jersey.config.client.proxy.uri", (Object)proxyUri)).property("jersey.config.client.proxy.username", (Object)proxyUser)).property("jersey.config.client.proxy.password", (Object)proxyPassword)).property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            }
        }
        if ((hostnameVerifier = configuration.getHostnameVerifier()) != null) {
            builder.hostnameVerifier(hostnameVerifier);
        }
        if ((sslContext = configuration.getSslContext()) != null) {
            builder.sslContext(sslContext);
        }
        return builder.build();
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CscClient getCscClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cscClient == null) {
                WebTarget apiBase = this.createClient(this.httpConfiguration).target(this.apiBaseUri);
                this.cscClient = new CscClient(apiBase);
            }
        }
        return this.cscClient;
    }

    protected void logConfiguration() {
        super.logConfiguration();
        this.logger.info("  +-- httpConfiguration: {}", (Object)this.httpConfiguration);
        this.logger.info("  +-- apiBaseUri: {}", (Object)this.apiBaseUri);
        this.logger.info("  +-- authorizationManager: {}", (Object)this.authorizationManager);
    }
}

