/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.csc.app.signature.CscSignerFactory;
import de.intarsys.security.device.csc.device.CscDevice;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class CscDeviceProvider
extends CommonDeviceProvider<CscDevice> {
    protected CscDevice basicCreateInstance(IArgs args) {
        return new CscDevice(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> applications) {
        super.declareApplicationDescriptors(applications);
        CscSignerFactory signerFactory = new CscSignerFactory();
        signerFactory.setDeviceProvider(this);
        signerFactory.setType(ISigner.class);
        signerFactory.setPolicy((IApplicationPolicy)new CommonSignerPolicy((CommonDeviceProvider)this));
        applications.add((IApplicationDescriptor)signerFactory);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.csc");
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

