/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.csc.oauth2;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import de.intarsys.security.device.csc.oauth2.SAD;
import java.util.HashMap;
import net.minidev.json.JSONObject;

public class TokenResponseParser {
    private static final String BEARER_TOKEN_TYPE = "Bearer";
    private static final String SAD_TOKEN_TYPE = "SAD";

    public static TokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        if (httpResponse.getStatusCode() != 200) {
            return TokenErrorResponse.parse((HTTPResponse)httpResponse);
        }
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        Tokens tokens = TokenResponseParser.parseTokens(jsonObject);
        HashMap customParameters = new HashMap(jsonObject);
        customParameters.keySet().removeAll(tokens.getParameterNames());
        return customParameters.isEmpty() ? new AccessTokenResponse(tokens) : new AccessTokenResponse(tokens, customParameters);
    }

    private static Tokens parseTokens(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = TokenResponseParser.parseAccessToken(jsonObject);
        RefreshToken refreshToken = RefreshToken.parse((JSONObject)jsonObject);
        return new Tokens(accessToken, refreshToken);
    }

    private static AccessToken parseAccessToken(JSONObject jsonObject) throws ParseException {
        String tokenType;
        return switch (tokenType = JSONObjectUtils.getString((JSONObject)jsonObject, (String)"token_type")) {
            case BEARER_TOKEN_TYPE -> BearerAccessToken.parse((JSONObject)jsonObject);
            case SAD_TOKEN_TYPE -> SAD.parse(jsonObject);
            default -> throw new ParseException("Unsupported token_type: " + tokenType);
        };
    }

    private TokenResponseParser() {
    }
}

