/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.authentication;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.authentication.CommonAuthenticator;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.authentication.PACKAGE;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class KeyStoreAuthenticator
extends CommonAuthenticator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ARG_SIGNER_STORE = "signerStore";
    private static final String RSA_PKCS1_ECB = "RSA/ECB/PKCS1PADDING";
    public static final String RSA_PKCS1_NONE = "RSA/NONE/PKCS1PADDING";
    private IX509PublicKeyCertificate certificate;
    private String label;
    private Cipher rsaCipher;

    public static Cipher lookupRSACipher(String provider) throws GeneralSecurityException {
        try {
            return Cipher.getInstance(RSA_PKCS1_NONE, provider);
        }
        catch (NoSuchAlgorithmException e) {
            return Cipher.getInstance(RSA_PKCS1_ECB, provider);
        }
    }

    protected KeyStoreAuthenticator(CommonDevice device, IX509PublicKeyCertificate paramKeyEntity) {
        super(device);
        this.certificate = paramKeyEntity;
        this.setCertificatePath(new IX509PublicKeyCertificate[]{this.certificate});
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider((IX509PublicKeyCertificate)this.getCertificate());
            IMessage prompt = this.getAuthenticationPromptExpanded();
            PrivateKey key = CommonDevice.getPrivateKey((IX509PublicKeyCertificate)this.getCertificate(), (CommonSecurityApplication)this, (IPrivateKeyProvider)provider, (Secret)this.getAuthenticationPin(), (IMessage)prompt);
            try {
                this.rsaCipher = KeyStoreAuthenticator.lookupRSACipher("BC");
                this.rsaCipher.init(1, key);
            }
            catch (GeneralSecurityException e) {
                throw new SecurityApplicationException(Msg.getString("KeyStoreAuthenticator.ErrorWrongAlgorithm", new Object[0]), (Throwable)e);
            }
        });
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.rsaCipher = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.rsaCipher = null;
        this.certificate = null;
    }

    protected byte[] basicSign(byte[] data) throws SecurityApplicationException {
        try {
            byte[] pkcs1 = this.rsaCipher.doFinal(data);
            return pkcs1;
        }
        catch (IllegalBlockSizeException e) {
            String msg = Msg.getString("KeyStoreAuthenticator.ExUnexpected", new Object[0]);
            throw new SecurityApplicationException(msg, (Throwable)e);
        }
        catch (BadPaddingException e) {
            String msg = Msg.getString("KeyStoreAuthenticator.ExUnexpected", new Object[0]);
            throw new SecurityApplicationException(msg, (Throwable)e);
        }
    }

    protected String getAuthenticationPromptDefault() {
        String message = Msg.getString("KeyStoreAuthenticator.passwordProvider.message", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.certificate)});
        return message;
    }

    protected IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = Msg.getString("KeyStoreAuthenticator.label", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.certificate)});
        }
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }
}

