/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.authentication;

import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.keystore.app.authentication.KeyStoreAuthenticator;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeyStoreAuthenticatorFactory
extends CommonSecurityApplicationFactory<KeystoreDevice, KeyStoreAuthenticator> {
    protected KeyStoreAuthenticator basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            IX509PublicKeyCertificate cert = this.getCertificate(args, "signerIdentifier");
            KeyStoreAuthenticator app = new KeyStoreAuthenticator(this.getDevice(args), cert);
            this.initAuthentication((ISecurityApplication)app, cert, args);
            if (this.isIncludeCertificatePath(args)) {
                app.buildCertificatePath();
            }
            return app;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider defaultProvider = ((KeystoreDevice)this.getDevice(args)).getCertificateProvider();
        if (defaultProvider == null) {
            defaultProvider = IdCertificateProvider.get();
        }
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)"signerStore", (ICertificateProvider)defaultProvider);
        return provider;
    }

    public Class<KeyStoreAuthenticator> getResultType() {
        return KeyStoreAuthenticator.class;
    }

    protected boolean isIncludeCertificatePath(IArgs args) {
        boolean value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificateChain", (boolean)true);
        value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificatePath", (boolean)value);
        return value;
    }
}

