/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.decryption;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.decryption.CommonDecryptor;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.decryption.PACKAGE;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.security.PrivateKey;

public abstract class CommonKeyStoreDecryptor
extends CommonDecryptor {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String ARG_DECRYPTOR_STORE = "decryptorStore";
    private IX509PublicKeyCertificate certificate;
    private char[] password;
    private String label;

    public CommonKeyStoreDecryptor(CommonDevice device, IX509PublicKeyCertificate certificate) {
        super(device);
        this.certificate = certificate;
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider((IX509PublicKeyCertificate)this.getCertificate());
            IMessage prompt = this.getAuthenticationPromptExpanded();
            PrivateKey key = CommonDevice.getPrivateKey((IX509PublicKeyCertificate)this.getCertificate(), (CommonSecurityApplication)this, (IPrivateKeyProvider)provider, (Secret)this.getAuthenticationPin(), (IMessage)prompt);
            this.init(key, provider.getProviderName());
        });
    }

    protected String getAuthenticationPromptDefault() {
        String message = Msg.getString("CommonKeyStoreDecryptor.passwordProvider.message", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate())});
        return message;
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = Msg.getString("CommonKeyStoreDecryptor.label", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate())});
        }
        return this.label;
    }

    public char[] getPassword() {
        return this.password;
    }

    protected abstract void init(PrivateKey var1, String var2) throws SecurityApplicationException;

    public void setPassword(char[] password) {
        this.password = password;
    }
}

