/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.decryption;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.DecryptedData;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.decryption.CommonKeyStoreDecryptor;
import de.intarsys.security.device.keystore.app.decryption.PACKAGE;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;

public class ECDHKeyStoreDecryptor
extends CommonKeyStoreDecryptor {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private KeyAgreement keyAgreement;

    public ECDHKeyStoreDecryptor(CommonDevice device, IX509PublicKeyCertificate certificate) {
        super(device, certificate);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        this.keyAgreement = null;
    }

    protected IDecryptedData basicDecrypt(IEncryptedData encryptedData) throws SecurityApplicationException {
        byte[] secret;
        try {
            KeyFactory factory = KeyFactory.getInstance("EC", "BC");
            PublicKey originatorPublicKey = factory.generatePublic(new X509EncodedKeySpec(LocatorTools.getBytes((ILocator)encryptedData.getLocator())));
            this.keyAgreement.doPhase(originatorPublicKey, true);
            secret = this.keyAgreement.generateSecret();
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        ByteArrayLocator locator = new ByteArrayLocator(secret, "decryptedData", "bin");
        return new DecryptedData((ILocator)locator);
    }

    @Override
    protected void init(PrivateKey privateKey, String providerName) throws SecurityApplicationException {
        try {
            this.keyAgreement = KeyAgreement.getInstance("ECDH", providerName);
            this.keyAgreement.init(privateKey);
        }
        catch (InvalidKeyException e) {
            String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
            throw new SecurityApplicationException(msg);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
            throw new SecurityApplicationException(msg);
        }
        catch (NoSuchProviderException e) {
            String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
            throw new SecurityApplicationException(msg);
        }
    }
}

