/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.decryption;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.keystore.app.decryption.CommonKeyStoreDecryptor;
import de.intarsys.security.device.keystore.app.decryption.ECDHKeyStoreDecryptor;
import de.intarsys.security.device.keystore.app.decryption.RSAKeyStoreDecryptor;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeyStoreDecryptorFactory
extends CommonSecurityApplicationFactory<KeystoreDevice, CommonKeyStoreDecryptor> {
    protected CommonKeyStoreDecryptor basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            IX509PublicKeyCertificate cert = this.getCertificate(args, "decryptorIdentifier");
            if (cert == null) {
                throw new ObjectCreationException("no decryptor certificate found");
            }
            CommonKeyStoreDecryptor app = PpkTools.isSignatureAlgorithmECDSA((String)cert.getPublicKey().getAlgorithm()) ? new ECDHKeyStoreDecryptor(this.getDevice(args), cert) : new RSAKeyStoreDecryptor(this.getDevice(args), cert);
            this.initAuthentication((ISecurityApplication)app, cert, args);
            return app;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "decryptorPassword";
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider defaultProvider = ((KeystoreDevice)this.getDevice(args)).getCertificateProvider();
        if (defaultProvider == null) {
            defaultProvider = IdCertificateProvider.get();
        }
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)"decryptorStore", (ICertificateProvider)defaultProvider);
        return provider;
    }

    public Class getResultType() {
        return IDecryptor.class;
    }
}

