/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.decryption;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.DecryptedData;
import de.intarsys.security.app.crypt.IDecryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.decryption.CommonKeyStoreDecryptor;
import de.intarsys.security.device.keystore.app.decryption.PACKAGE;
import de.intarsys.security.device.keystore.app.encryption.RSAKeyStoreEncryptor;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAKeyStoreDecryptor
extends CommonKeyStoreDecryptor {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final String RSA_PKCS1_ECB = "RSA/ECB/PKCS1PADDING";
    public static final String RSA_PKCS1_NONE = "RSA/NONE/PKCS1PADDING";
    public static final String OID_RSA_PKCS1 = "1.2.840.113549.1.1.1";
    public static final String OID_RSAES_OAEP = "1.2.840.113549.1.1.7";
    private PrivateKey privateKey;
    private String providerName;

    public RSAKeyStoreDecryptor(CommonDevice device, IX509PublicKeyCertificate certificate) {
        super(device, certificate);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        this.privateKey = null;
    }

    protected IDecryptedData basicDecrypt(IEncryptedData encryptedData) throws SecurityApplicationException {
        byte[] decryptedData;
        Cipher rsaCipher = this.initCipher(encryptedData);
        InputStream is = null;
        try {
            is = encryptedData.getLocator().getInputStream();
            decryptedData = rsaCipher.doFinal(StreamTools.getBytes((InputStream)is));
        }
        catch (BadPaddingException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        ByteArrayLocator locator = new ByteArrayLocator(decryptedData, "decryptedData", "bin");
        return new DecryptedData((ILocator)locator);
    }

    @Override
    protected void init(PrivateKey privateKey, String providerName) throws SecurityApplicationException {
        this.privateKey = privateKey;
        this.providerName = providerName;
    }

    protected Cipher initCipher(IEncryptedData encryptedData) throws SecurityApplicationException {
        String algorithmOid;
        switch (algorithmOid = encryptedData.getAlgorithmOID()) {
            case "1.2.840.113549.1.1.1": {
                try {
                    Cipher rsaCipher = RSAKeyStoreEncryptor.lookupRSACipher(this.providerName);
                    rsaCipher.init(2, this.privateKey);
                    return rsaCipher;
                }
                catch (InvalidKeyException e) {
                    String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
                    throw new SecurityApplicationException(msg);
                }
                catch (NoSuchAlgorithmException e) {
                    String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
                    throw new SecurityApplicationException(msg);
                }
            }
            case "1.2.840.113549.1.1.7": {
                try {
                    Cipher rsaCipher = Cipher.getInstance("RSA/None/OAEPPadding", this.providerName);
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP", this.providerName);
                    algorithmParameters.init(encryptedData.getAlgorithmParameters());
                    rsaCipher.init(2, (Key)this.privateKey, algorithmParameters);
                    return rsaCipher;
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
                    String msg = Msg.getString("KeyStoreDecryptor.ErrorWrongAlgorithm", new Object[0]);
                    throw new SecurityApplicationException(msg);
                }
                catch (IOException e) {
                    throw new SecurityApplicationException((Throwable)e);
                }
            }
        }
        throw new SecurityApplicationException("Unsupported algorithm: " + algorithmOid);
    }
}

