/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.encryption;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.encryption.CommonEncryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.encryption.ECDHKeyStoreEncryptor;
import de.intarsys.security.device.keystore.app.encryption.RSAKeyStoreEncryptor;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.PublicKey;

public abstract class CommonKeyStoreEncryptor
extends CommonEncryptor {
    private IX509PublicKeyCertificate certificate;

    public static CommonKeyStoreEncryptor create(CommonDevice device, IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        PublicKey key = certificate.getPublicKey();
        if (key == null) {
            throw new IllegalArgumentException("didn't receive the public key - check keystore");
        }
        CommonKeyStoreEncryptor securityApp = PpkTools.isSignatureAlgorithmECDSA((String)key.getAlgorithm()) ? new ECDHKeyStoreEncryptor(device, certificate) : new RSAKeyStoreEncryptor(device, certificate);
        securityApp.init();
        return securityApp;
    }

    public CommonKeyStoreEncryptor(CommonDevice device, IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        super(device);
        this.certificate = certificate;
    }

    public IX509PublicKeyCertificate getCertificate() {
        return this.certificate;
    }

    public void init() {
    }
}

