/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.encryption;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.EncryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.encryption.CommonKeyStoreEncryptor;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.KeyAgreement;

public class ECDHKeyStoreEncryptor
extends CommonKeyStoreEncryptor {
    public ECDHKeyStoreEncryptor(CommonDevice device, IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        super(device, certificate);
    }

    public IEncryptedData encrypt(byte[] data) throws SecurityApplicationException {
        PublicKey recipientKey = this.getCertificate().getPublicKey();
        if (recipientKey == null) {
            throw new IllegalArgumentException("didn't receive the public key - check keystore");
        }
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH", "BC");
            KeyFactory factory = KeyFactory.getInstance("EC", "BC");
            PrivateKey privateKey = factory.generatePrivate(new PKCS8EncodedKeySpec(data));
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(this.getCertificate().getPublicKey(), true);
            byte[] secret = keyAgreement.generateSecret();
            EncryptedData result = new EncryptedData((ILocator)new ByteArrayLocator(secret, "temp", "unknown"));
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }
}

