/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.encryption;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.encryption.CommonEncryptorFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.keystore.app.encryption.CommonKeyStoreEncryptor;
import de.intarsys.security.device.keystore.app.encryption.ECDHKeyStoreEncryptor;
import de.intarsys.security.device.keystore.app.encryption.RSAESOAEPKeyStoreEncryptor;
import de.intarsys.security.device.keystore.app.encryption.RSAKeyStoreEncryptor;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class KeyStoreEncryptorFactory
extends CommonEncryptorFactory<KeystoreDevice, CommonKeyStoreEncryptor> {
    public static final String ARG_ENCRYPTOR_STORE = "encryptorStore";
    public static final String ARG_RSAENCODING = "rsaEncoding";
    public static final String ARG_DIGESTER = "digester";
    public static final String ENCODING_RSA = "RSA";
    public static final String ENCODING_RSAESOAEP = "RSAES-OAEP";

    public static IX509PublicKeyCertificate getEncryptorCertificate(IArgs args) throws SecurityApplicationException {
        try {
            ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)ARG_ENCRYPTOR_STORE, (ICertificateProvider)IdCertificateProvider.get());
            IX509CertificateFilter selector = CertificateFilterTools.getCertificateFilter((IArgs)args, (String)"encryptorIdentifier");
            if (selector == null) {
                throw new SecurityApplicationException("certificate not found");
            }
            IX509Certificate certificate = CertificateProviderTools.getCertificate((IArgs)args, (String)"encryptorIdentifier", (ICertificateProvider)provider);
            if (!(certificate instanceof IX509PublicKeyCertificate)) {
                throw new SecurityApplicationException("encryptorIdentifier is no key certificate");
            }
            return (IX509PublicKeyCertificate)certificate;
        }
        catch (SecurityApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected CommonKeyStoreEncryptor basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            CommonKeyStoreEncryptor securityApp;
            IX509PublicKeyCertificate encryptorCert = KeyStoreEncryptorFactory.getEncryptorCertificate(args);
            if (PpkTools.isSignatureAlgorithmECDSA((String)encryptorCert.getPublicKey().getAlgorithm())) {
                securityApp = new ECDHKeyStoreEncryptor(this.getDevice(args), encryptorCert);
            } else {
                String encoding = this.getPreferredRSAEncoding(encryptorCert);
                if (encoding == null && StringTools.isEmpty((String)(encoding = ArgTools.getString((IArgs)args, (String)ARG_RSAENCODING, (String)((KeystoreDevice)this.getDevice(args)).getRsaEncryptionEncoding())))) {
                    encoding = ENCODING_RSA;
                }
                switch (encoding) {
                    case "RSA": {
                        securityApp = new RSAKeyStoreEncryptor(this.getDevice(args), encryptorCert);
                        break;
                    }
                    case "RSAES-OAEP": {
                        RSAESOAEPKeyStoreEncryptor encryptor = new RSAESOAEPKeyStoreEncryptor(this.getDevice(args), encryptorCert);
                        encryptor.setDigestAlgorithm(ArgTools.getString((IArgs)args, (String)ARG_DIGESTER, null));
                        securityApp = encryptor;
                        break;
                    }
                    default: {
                        throw new ObjectCreationException("Unsupported encoding: " + encoding);
                    }
                }
            }
            securityApp.init();
            return securityApp;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider defaultProvider = ((KeystoreDevice)this.getDevice(args)).getCertificateProvider();
        if (defaultProvider == null) {
            defaultProvider = IdCertificateProvider.get();
        }
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)ARG_ENCRYPTOR_STORE, (ICertificateProvider)defaultProvider);
        return provider;
    }

    protected String getPreferredRSAEncoding(IX509PublicKeyCertificate encryptorCert) {
        PublicKey publicKey = encryptorCert.getPublicKey();
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        String algorithmId = keyInfo.getAlgorithm().getAlgorithm().getId();
        if ("1.2.840.113549.1.1.7".equals(algorithmId)) {
            return ENCODING_RSAESOAEP;
        }
        return null;
    }
}

