/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.encryption;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.EncryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.encryption.CommonKeyStoreEncryptor;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class RSAESOAEPKeyStoreEncryptor
extends CommonKeyStoreEncryptor {
    public static final String OID_RSAES_OAEP = "1.2.840.113549.1.1.7";
    private Cipher cipher;
    private String defaultDigestAlgorithm = "SHA-1";
    private String defaultMgfAlgorithm = "mgf1";
    private String digestAlgorithm;
    private String mgfAlgorithm;
    private RSAESOAEPparams params;

    public RSAESOAEPKeyStoreEncryptor(CommonDevice device, IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        super(device, certificate);
    }

    protected void basicDispose() {
        super.basicDispose();
        this.cipher = null;
        this.params = null;
    }

    protected RSAESOAEPparams createParameters(String digestAlgorithmName, String mgfName) {
        String digestAlgorithmOID = DigestAlgorithm.lookupOID((String)digestAlgorithmName);
        String mgfOid = null;
        switch (mgfName) {
            case "mgf1": {
                mgfOid = "1.2.840.113549.1.1.8";
            }
        }
        AlgorithmIdentifier digestAlgorithmIdentifier = RSAESOAEPparams.DEFAULT_HASH_ALGORITHM;
        AlgorithmIdentifier mgfAlgorithmIdentifier = RSAESOAEPparams.DEFAULT_MASK_GEN_FUNCTION;
        AlgorithmIdentifier pSourceAlgorithmIdentifier = RSAESOAEPparams.DEFAULT_P_SOURCE_ALGORITHM;
        if (digestAlgorithmOID != null) {
            digestAlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(digestAlgorithmOID), (ASN1Encodable)DERNull.INSTANCE);
        }
        if (mgfOid != null) {
            mgfAlgorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(mgfOid), (ASN1Encodable)digestAlgorithmIdentifier);
        }
        return new RSAESOAEPparams(digestAlgorithmIdentifier, mgfAlgorithmIdentifier, pSourceAlgorithmIdentifier);
    }

    public IEncryptedData encrypt(byte[] data) throws SecurityApplicationException {
        byte[] encryptedData;
        try {
            encryptedData = this.cipher.doFinal(data);
        }
        catch (BadPaddingException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        EncryptedData result = new EncryptedData((ILocator)new ByteArrayLocator(encryptedData, "temp", "unknown"), OID_RSAES_OAEP);
        if (this.params != null) {
            try {
                result.setAlgorithmParameters(this.params.getEncoded());
            }
            catch (IOException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
        }
        return result;
    }

    public String getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    public String getDefaultMgfAlgorithm() {
        return this.defaultMgfAlgorithm;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public String getMgfAlgorithm() {
        return this.mgfAlgorithm;
    }

    @Override
    public void init() {
        RSAESOAEPparams keyParams;
        super.init();
        PublicKey key = this.getCertificate().getPublicKey();
        if (key == null) {
            throw new IllegalArgumentException("didn't receive the public key - check keystore");
        }
        String digestAlgorithm = this.getDigestAlgorithm();
        String mgfAlgorithm = this.getMgfAlgorithm();
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)key.getEncoded());
        String algorithmId = keyInfo.getAlgorithm().getAlgorithm().getId();
        if (OID_RSAES_OAEP.equals(algorithmId) && (keyParams = RSAESOAEPparams.getInstance((Object)keyInfo.getAlgorithm().getParameters())) != null) {
            if (digestAlgorithm == null) {
                digestAlgorithm = DigestAlgorithm.lookupAlgorithmName((String)keyParams.getHashAlgorithm().getAlgorithm().getId());
            }
            if (mgfAlgorithm == null) {
                String mgfAlgorithmOid;
                switch (mgfAlgorithmOid = keyParams.getMaskGenAlgorithm().getAlgorithm().getId()) {
                    case "1.2.840.113549.1.1.8": {
                        mgfAlgorithm = "mgf1";
                        break;
                    }
                }
            }
        }
        digestAlgorithm = digestAlgorithm == null ? this.getDefaultDigestAlgorithm() : digestAlgorithm;
        mgfAlgorithm = mgfAlgorithm == null ? this.getDefaultMgfAlgorithm() : mgfAlgorithm;
        this.params = this.createParameters(digestAlgorithm, mgfAlgorithm);
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP", "BC");
            algorithmParameters.init(this.params.getEncoded());
            this.cipher = Cipher.getInstance("RSA/None/OAEPPadding");
            this.cipher.init(1, (Key)key, algorithmParameters);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("the key entities private key is not a RSA key", e);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Algorithm not available.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setDefaultDigestAlgorithm(String defaultDigestAlgorithm) {
        this.defaultDigestAlgorithm = defaultDigestAlgorithm;
    }

    public void setDefaultMgfAlgorithm(String defaultMgfAlgorithm) {
        this.defaultMgfAlgorithm = defaultMgfAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setMgfAlgorithm(String mgfAlgorithm) {
        this.mgfAlgorithm = mgfAlgorithm;
    }
}

