/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.encryption;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.EncryptedData;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.encryption.CommonKeyStoreEncryptor;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAKeyStoreEncryptor
extends CommonKeyStoreEncryptor {
    public static final String RSA_PKCS1_ECB = "RSA/ECB/PKCS1PADDING";
    public static final String RSA_PKCS1_NONE = "RSA/NONE/PKCS1PADDING";
    public static final String OID_RSA = "1.2.840.113549.1.1.1";
    private Cipher cipher;

    public static Cipher lookupRSACipher(String provider) throws NoSuchAlgorithmException {
        try {
            try {
                return Cipher.getInstance(RSA_PKCS1_NONE, provider);
            }
            catch (NoSuchAlgorithmException e) {
                return Cipher.getInstance(RSA_PKCS1_ECB, provider);
            }
        }
        catch (NoSuchProviderException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new NoSuchAlgorithmException(e);
        }
    }

    public RSAKeyStoreEncryptor(CommonDevice device, IX509PublicKeyCertificate certificate) throws ObjectCreationException {
        super(device, certificate);
    }

    protected void basicDispose() {
        super.basicDispose();
        this.cipher = null;
    }

    public IEncryptedData encrypt(byte[] data) throws SecurityApplicationException {
        byte[] encryptedData;
        try {
            encryptedData = this.cipher.doFinal(data);
        }
        catch (BadPaddingException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        return new EncryptedData((ILocator)new ByteArrayLocator(encryptedData, "temp", "unknown"), OID_RSA);
    }

    @Override
    public void init() {
        super.init();
        PublicKey key = this.getCertificate().getPublicKey();
        if (key == null) {
            throw new IllegalArgumentException("didn't receive the public key - check keystore");
        }
        try {
            this.cipher = RSAKeyStoreEncryptor.lookupRSACipher("BC");
            this.cipher.init(1, key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("the key entities private key is not a RSA key", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algorithm 'RSA/NONE/PKCS1PADDING' or 'RSA/ECB/PKCS1PADDING' must be available.", e);
        }
    }
}

