/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.principals;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.principal.CommonPrincipalAdministration;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystorePrincipal;
import de.intarsys.security.device.software.device.SoftwareDeviceProvider;
import de.intarsys.security.device.software.device.SoftwareSigner;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.function.Throwing;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Iterator;

public class KeystorePrincipalAdministration
extends CommonPrincipalAdministration {
    public static final String ARG_PASSWORD = "password";
    public static final String ARG_KEYPAIRGENERATOR = "keyPairGenerator";
    private IKeyPairGenerator keyPairGenerator;
    private IPublicKeyCertifier certifier;

    public KeystorePrincipalAdministration(CommonDevice device) {
        super(device);
    }

    protected KeystoreDevice basicGetDevice() {
        return (KeystoreDevice)super.basicGetDevice();
    }

    public boolean canCreate() {
        return this.basicGetDevice().isPrincipalStoreSupported();
    }

    public boolean canDelete() {
        return this.basicGetDevice().isPrincipalDeleteSupported();
    }

    protected IX509PublicKeyCertificate createCertificate(final KeyPair keyPair) throws SecurityApplicationException {
        Throwing.Specific.Supplier<ISigner, Exception> signerSupplier = new Throwing.Specific.Supplier<ISigner, Exception>(){

            public ISigner get() throws Exception {
                CommonDevice device = (CommonDevice)DeviceTools.toDeviceProvider(SoftwareDeviceProvider.class).listDevices(null).next();
                SoftwareSigner signer = new SoftwareSigner(device, keyPair.getPrivate());
                signer.authenticate().get();
                return signer;
            }
        };
        IX509PublicKeyCertificate certificate = this.getCertifier().certify(keyPair.getPublic(), (Throwing.Specific.Supplier)signerSupplier);
        return certificate;
    }

    public IConversation<IPrincipal> createPrincipal() throws SecurityApplicationException {
        KeyPair keyPair;
        try {
            keyPair = this.getKeyPairGenerator().generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
        }
        IX509PublicKeyCertificate certificate = this.createCertificate(keyPair);
        Secret password = null;
        if (this.getPasswordProvider() != null) {
            password = this.getPasswordProvider().getPassword();
        }
        this.basicGetDevice().principalStore(certificate, keyPair, password);
        Iterator principals = this.getDevice().listPrincipals(principal -> {
            if (principal instanceof IX509PublicKeyCertificateOwner) {
                IX509PublicKeyCertificate otherCert = ((IX509PublicKeyCertificateOwner)principal).getX509PublicKeyCertificate();
                return certificate.equals(otherCert);
            }
            return false;
        });
        if (!principals.hasNext()) {
            throw new SecurityApplicationException("principal creation failed");
        }
        IPrincipal principal2 = (IPrincipal)principals.next();
        return Conversation.completed((Object)principal2);
    }

    public void deletePrincipal(IPrincipalFilter principalFilter) throws SecurityApplicationException {
        Iterator principals = this.basicGetDevice().listPrincipals(principalFilter);
        if (!principals.hasNext()) {
            throw new SecurityApplicationException("no principal found");
        }
        KeystorePrincipal principal = (KeystorePrincipal)((Object)principals.next());
        IX509PublicKeyCertificate certificate = principal.getX509PublicKeyCertificate();
        this.basicGetDevice().principalDelete(certificate);
    }

    public IPublicKeyCertifier getCertifier() {
        return this.certifier;
    }

    public IKeyPairGenerator getKeyPairGenerator() {
        return this.keyPairGenerator;
    }

    public void setCertifier(IPublicKeyCertifier certifier) {
        this.certifier = certifier;
    }

    public void setKeyPairGenerator(IKeyPairGenerator keyPairGenerator) {
        this.keyPairGenerator = keyPairGenerator;
    }
}

