/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.principals;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.app.principal.IPrincipalAdministration;
import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.device.keystore.app.principals.KeystorePrincipalAdministration;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.List;

public class KeystorePrincipalAdministrationFactory
extends CommonSecurityApplicationFactory<KeystoreDevice, KeystorePrincipalAdministration> {
    protected KeystorePrincipalAdministration basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            IFactory<IPublicKeyCertifier> certifierFactory;
            KeystoreDevice device = (KeystoreDevice)this.getDevice(args);
            KeystorePrincipalAdministration app = new KeystorePrincipalAdministration(device);
            IArgs keyPairGeneratorArgs = ArgTools.getArgs((IArgs)args, (String)"keyPairGenerator", (IArgs)Args.create());
            IFactory<IKeyPairGenerator> keyPairGeneratorFactory = device.getKeyPairGeneratorFactory();
            if (keyPairGeneratorFactory != null) {
                IKeyPairGenerator keyPairGenerator = (IKeyPairGenerator)keyPairGeneratorFactory.createInstance(keyPairGeneratorArgs);
                app.setKeyPairGenerator(keyPairGenerator);
            }
            if ((certifierFactory = device.getCertifierFactory()) != null) {
                IPublicKeyCertifier certifier = (IPublicKeyCertifier)certifierFactory.createInstance(args);
                app.setCertifier(certifier);
            }
            Secret password = ArgTools.getSecretHide((IArgs)args, (String)"password", null);
            app.setPasswordProvider(() -> password);
            return app;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    public List<String> getOperations(IDevice device) throws ApplicationException {
        if (device == null) {
            return super.getOperations(device);
        }
        try {
            KeystorePrincipalAdministration app = (KeystorePrincipalAdministration)((KeystoreDevice)device).basicCreateApplication((IFactory)this, (IArgs)Args.create());
            ArrayList<String> list = new ArrayList<String>();
            if (app.canCreate()) {
                list.add("create");
            }
            if (app.canDelete()) {
                list.add("delete");
            }
            return list;
        }
        catch (ObjectCreationException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public Class getResultType() {
        return IPrincipalAdministration.class;
    }
}

