/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.signature.CommonSingleSigner;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.keystore.app.signature.PACKAGE;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.keystore.environment.KeystoreEnvironment;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;

public abstract class CommonKeyStoreSigner
extends CommonSingleSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList("MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512", "RIPEMD160", "RIPEMD256");
    public static final String ARG_SIGNER_STORE = "signerStore";
    private String label;

    protected CommonKeyStoreSigner(KeystoreDevice device, IX509PublicKeyCertificate certificate) {
        super((CommonDevice)device);
        this.setCertificatePath(new IX509PublicKeyCertificate[]{certificate});
    }

    protected IConversation<Void> basicAuthenticate() {
        return super.basicAuthenticate().thenAccept(ignore -> {
            IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider((IX509PublicKeyCertificate)this.getCertificate());
            IMessage prompt = this.getAuthenticationPromptExpanded();
            PrivateKey key = CommonDevice.getPrivateKey((IX509PublicKeyCertificate)this.getCertificate(), (CommonSecurityApplication)this, (IPrivateKeyProvider)provider, (Secret)this.getAuthenticationPin(), (IMessage)prompt);
            this.init(key, provider.getProviderName());
        });
    }

    protected IPrincipal createPrincipal(IX509PublicKeyCertificate certificate) {
        return this.getDevice().createPrincipal((IX509Certificate)certificate);
    }

    protected String getAuthenticationPromptDefault() {
        String message = Msg.getString("KeyStoreSigner.passwordProvider.message", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate())});
        return message;
    }

    public KeystoreDevice getDevice() {
        return (KeystoreDevice)super.getDevice();
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = Msg.getString("KeyStoreSigner.label", new Object[]{CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate())});
        }
        return this.label;
    }

    public String getPreferredHashAlgorithmName() {
        return KeystoreEnvironment.get().getSignatureHashAlgorithm();
    }

    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    protected abstract void init(PrivateKey var1, String var2) throws SecurityApplicationException;

    public boolean isBasic() {
        return true;
    }

    public String toString() {
        return this.getLabel();
    }
}

