/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.keystore.app.signature.CommonKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.PACKAGE;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.message.IMessageBundle;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class ECDSAKeyStoreSigner
extends CommonKeyStoreSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Signature signature;

    public ECDSAKeyStoreSigner(KeystoreDevice device, IX509PublicKeyCertificate certificate) {
        super(device, certificate);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.signature = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.signature = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            byte[] decodedDigest = data.getDigest().getBytes();
            this.signature.update(decodedDigest);
            byte[] bSignature = this.signature.sign();
            return Conversation.completed((Object)SignatureData.create((byte[])bSignature));
        }
        catch (SignatureException e) {
            String msg = Msg.getString("KeyStoreSigner.ExUnexpected", new Object[0]);
            return Conversation.failed((Throwable)new SecurityApplicationException(msg, (Throwable)e));
        }
    }

    public String getEncryptionAlgorithmName() {
        return "ECDSA";
    }

    @Override
    protected void init(PrivateKey privateKey, String providerName) throws SecurityApplicationException {
        try {
            this.signature = Signature.getInstance("NONEwithECDSA", "BC");
            this.signature.initSign(privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException(Msg.getString("KeyStoreSigner.ErrorWrongAlgorithm", new Object[0]), (Throwable)e);
        }
    }
}

