/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.signature.CommonSignerFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.certificate.provider.standard.PreselectCertificateProvider;
import de.intarsys.security.device.keystore.app.signature.CommonKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.ECDSAKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.RSAKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.RSASSAPSSKeyStoreSigner;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeyStoreSignerFactory
extends CommonSignerFactory<KeystoreDevice, CommonKeyStoreSigner> {
    public static final String RSAENCODING_RSA = "RSA";
    public static final String RSAENCODING_RSASSAPSS = "RSASSA-PSS";
    public static final String ARG_RSASIGNATUREENCODING = "rsaSignatureEncoding";
    public static final String ARG_RSAENCRYPTIONENCODING = "rsaEncryptionEncoding";
    private String rsaEncryptionEncoding;
    private String defaultRsaSignatureEncoding;

    protected CommonKeyStoreSigner basicCreateApp(IArgs args) throws ObjectCreationException {
        try {
            CommonKeyStoreSigner app;
            IX509PublicKeyCertificate cert = this.getCertificate(args, "signerIdentifier");
            if (cert == null) {
                throw new ObjectCreationException("no signer certificate found");
            }
            if (PpkTools.isSignatureAlgorithmECDSA((String)cert.getPublicKey().getAlgorithm())) {
                app = new ECDSAKeyStoreSigner((KeystoreDevice)this.getDevice(args), cert);
            } else {
                String encoding;
                switch (encoding = ArgTools.getString((IArgs)args, (String)ARG_RSASIGNATUREENCODING, (String)this.getDefaultRsaSignatureEncoding())) {
                    case "RSA": {
                        app = new RSAKeyStoreSigner((KeystoreDevice)this.getDevice(args), cert);
                        break;
                    }
                    case "RSASSA-PSS": {
                        app = new RSASSAPSSKeyStoreSigner((KeystoreDevice)this.getDevice(args), cert);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported encoding: " + encoding);
                    }
                }
            }
            this.initAuthentication((ISecurityApplication)app, cert, args);
            if (this.isIncludeCertificatePath(args)) {
                app.buildCertificatePath();
            }
            return app;
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    protected String getArgNamePassword() {
        return "signerPassword";
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)"signerStore", null);
        if (provider == null) {
            provider = ((KeystoreDevice)this.getDevice(args)).getCertificateProvider();
        }
        if (provider == null) {
            provider = IdCertificateProvider.get();
        } else {
            X509CertificateSelector selector = new X509CertificateSelector();
            selector.setHasPrivateKey(Boolean.valueOf(true));
            provider = new PreselectCertificateProvider((IX509CertificateFilter)selector, provider);
        }
        return provider;
    }

    public String getDefaultRsaSignatureEncoding() {
        if (this.defaultRsaSignatureEncoding == null) {
            this.defaultRsaSignatureEncoding = RSAENCODING_RSA;
        }
        return this.defaultRsaSignatureEncoding;
    }

    public Class<CommonKeyStoreSigner> getResultType() {
        return CommonKeyStoreSigner.class;
    }

    public String getRsaEncryptionEncoding() {
        return this.rsaEncryptionEncoding;
    }

    public boolean isIncludeCertificatePath(IArgs args) {
        boolean value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificateChain", (boolean)true);
        value = ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificatePath", (boolean)value);
        return value;
    }

    public void setDefaultRsaSignatureEncoding(String rsaSignatureEncoding) {
        this.defaultRsaSignatureEncoding = rsaSignatureEncoding;
    }

    public void setRsaEncryptionEncoding(String rsaEncryptionEncoding) {
        this.rsaEncryptionEncoding = rsaEncryptionEncoding;
    }
}

