/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.security.KeyStore;

public class KeyStoreSignerTools {
    public static ISigner createKeyStoreSigner(KeyStore keyStore, String alias) throws SecurityApplicationException {
        try {
            KeyStoreCertificateProvider provider = new KeyStoreCertificateProvider(keyStore);
            IX509PublicKeyCertificate signerCertificate = (IX509PublicKeyCertificate)provider.getCertificate(alias);
            Args args = Args.create();
            args.put("signerIdentifier", (Object)signerCertificate);
            String id = ISigner.class.getName();
            return (ISigner)DeviceTools.getDefaultDevice(KeystoreDeviceProvider.class).createApplication(id, (IArgs)args);
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }
}

