/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.algorithm.rsa.RsaTools;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.keystore.app.signature.CommonKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.PACKAGE;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.message.IMessageBundle;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class RSAKeyStoreSigner
extends CommonKeyStoreSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Cipher rsaCipher;

    public RSAKeyStoreSigner(KeystoreDevice device, IX509PublicKeyCertificate certificate) {
        super(device, certificate);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.rsaCipher = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.rsaCipher = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            byte[] pkcs1 = this.rsaCipher.doFinal(data.getEncodedDigest());
            return Conversation.completed((Object)SignatureData.create((byte[])pkcs1));
        }
        catch (IllegalBlockSizeException e) {
            String msg = Msg.getString("KeyStoreSigner.ExUnexpected", new Object[0]);
            return Conversation.failed((Throwable)new SecurityApplicationException(msg, (Throwable)e));
        }
        catch (BadPaddingException e) {
            String msg = Msg.getString("KeyStoreSigner.ExUnexpected", new Object[0]);
            return Conversation.failed((Throwable)new SecurityApplicationException(msg, (Throwable)e));
        }
    }

    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    @Override
    protected void init(PrivateKey privateKey, String providerName) throws SecurityApplicationException {
        try {
            this.rsaCipher = RsaTools.lookupRSACipher((String)providerName);
            this.rsaCipher.init(1, privateKey);
        }
        catch (InvalidKeyException e) {
            throw new SecurityApplicationException(Msg.getString("KeyStoreSigner.ErrorWrongAlgorithm", new Object[0]), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityApplicationException(Msg.getString("KeyStoreSigner.ErrorWrongAlgorithm", new Object[0]), (Throwable)e);
        }
    }
}

