/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.app.signature;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.keystore.app.signature.CommonKeyStoreSigner;
import de.intarsys.security.device.keystore.app.signature.PACKAGE;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.encoding.PSSEncoding;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.message.IMessageBundle;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collection;

public class RSASSAPSSKeyStoreSigner
extends CommonKeyStoreSigner {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Collection<String> SUPPORTED_DIGEST_ALGORITHMS = Arrays.asList("MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512");
    private Signature signature;
    private PrivateKey privateKey;

    public RSASSAPSSKeyStoreSigner(KeystoreDevice device, IX509PublicKeyCertificate certificate) {
        super(device, certificate);
    }

    protected void basicDeauthenticate() throws SecurityApplicationException {
        super.basicDeauthenticate();
        this.signature = null;
        this.privateKey = null;
    }

    protected void basicDispose() {
        super.basicDispose();
        this.signature = null;
        this.privateKey = null;
    }

    protected IConversation<ISignatureData> basicSignSingle(IToBeSignedData data) {
        try {
            this.setAlgorithmParameterSpec(PSSEncoding.createPSSParameterSpec((String)data.getDigest().getAlgorithmName()));
            this.signature.setParameter(this.getAlgorithmParameterSpec());
            this.signature.initSign(this.privateKey);
            byte[] decodedDigest = data.getDigest().getBytes();
            this.signature.update(decodedDigest);
            byte[] bSignature = this.signature.sign();
            return Conversation.completed((Object)SignatureData.create((byte[])bSignature));
        }
        catch (InvalidAlgorithmParameterException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException(Msg.getString("KeyStoreSigner.ErrorWrongAlgorithm", new Object[0]), (Throwable)e));
        }
        catch (GeneralSecurityException e) {
            String msg = Msg.getString("KeyStoreSigner.ExUnexpected", new Object[0]);
            return Conversation.failed((Throwable)new SecurityApplicationException(msg, (Throwable)e));
        }
    }

    public String getEncryptionAlgorithmName() {
        return "RSA";
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        return SUPPORTED_DIGEST_ALGORITHMS;
    }

    @Override
    protected void init(PrivateKey privateKey, String providerName) throws SecurityApplicationException {
        try {
            this.signature = Signature.getInstance("RAWRSASSA-PSS", "BC");
            this.signature.initSign(privateKey);
            this.privateKey = privateKey;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityApplicationException(Msg.getString("KeyStoreSigner.ErrorWrongAlgorithm", new Object[0]), (Throwable)e);
        }
    }
}

