/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.certificate;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.collection.NullFilterIterator;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreCertificateProvider
implements ICertificateProvider {
    private static final Logger Log = LoggerFactory.getLogger(KeystoreCertificateProvider.class);

    public boolean containsCertificate(IX509Certificate certificate) {
        for (ICertificateProvider delegate : IterableTools.in(this.getDeviceCertificateProviders())) {
            if (!delegate.containsCertificate(certificate)) continue;
            return true;
        }
        return false;
    }

    protected Iterator<ICertificateProvider> getDeviceCertificateProviders() {
        try {
            IDeviceProvider deviceProvider = DeviceTools.toDeviceProvider(KeystoreDeviceProvider.class);
            ConversionIterator<IDevice, ICertificateProvider> iter = new ConversionIterator<IDevice, ICertificateProvider>(deviceProvider.listDevices(null)){

                protected ICertificateProvider createTargetObject(IDevice sourceObject) {
                    return ((KeystoreDevice)sourceObject).getCertificateProvider();
                }
            };
            iter = new NullFilterIterator((Iterator)iter);
            return iter;
        }
        catch (ObjectCreationException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyIterator();
        }
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        ArrayList<Iterator> result = new ArrayList<Iterator>();
        for (ICertificateProvider delegate : IterableTools.in(this.getDeviceCertificateProviders())) {
            Iterator delegateResult = delegate.lookupCertificates(filter);
            result.add(delegateResult);
        }
        return new NestedIterator(result.iterator());
    }
}

