/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.device;

import de.intarsys.security.app.common.CommonSecurityApplication;
import de.intarsys.security.app.common.CommonSecurityApplicationFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceSupport;
import de.intarsys.security.device.keystore.device.DispatchKeystoreDevice;
import de.intarsys.security.device.keystore.device.DispatchKeystoreDeviceProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class DispatchKeystoreAppFactory<T extends CommonSecurityApplication>
extends CommonSecurityApplicationFactory<DispatchKeystoreDevice, T> {
    private final String certificateRole;

    public DispatchKeystoreAppFactory(String certificateRole) {
        this.certificateRole = certificateRole;
    }

    protected IDevice createDelegateDevice(IArgs args) throws ObjectCreationException {
        ICertificateProvider certificateProvider;
        IX509PublicKeyCertificate certificate = this.getCertificate(args, this.getCertificateRole() + "Identifier");
        IDevice device = null;
        if (certificate != null && (certificateProvider = certificate.getCertificateProvider()) instanceof IDeviceSupport) {
            device = ((IDeviceSupport)certificateProvider).getDevice();
        }
        if (device == null) {
            device = DeviceTools.getDefaultDevice((Object)((Object)((DispatchKeystoreDeviceProvider)((DispatchKeystoreDevice)this.getDevice(args)).getDeviceProvider()).getDefaultDeviceProvider()));
        }
        return device;
    }

    public T createInstance(IArgs args) throws ObjectCreationException {
        IDevice device = this.createDelegateDevice(args);
        return (T)((CommonSecurityApplication)device.createApplication(this.getType().getName(), args));
    }

    protected ICertificateProvider getCertificateProvider(IArgs args) throws ObjectCreationException {
        ICertificateProvider defaultProvider = IdCertificateProvider.get();
        ICertificateProvider provider = CertificateProviderTools.getCertificateProvider((IArgs)args, (String)(this.getCertificateRole() + "Store"), (ICertificateProvider)defaultProvider);
        return provider;
    }

    public String getCertificateRole() {
        return this.certificateRole;
    }

    public Class<T> getResultType() {
        return this.getType();
    }
}

