/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.keystore.device.DispatchKeystoreAppFactory;
import de.intarsys.security.device.keystore.device.DispatchKeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class DispatchKeystoreDeviceProvider
extends CommonDeviceProvider<DispatchKeystoreDevice> {
    private KeystoreDeviceProvider defaultDeviceProvider;

    protected DispatchKeystoreDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        return new DispatchKeystoreDevice(this, this.getId(args));
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        DispatchKeystoreAppFactory descriptor = new DispatchKeystoreAppFactory("signer");
        descriptor.setDeviceProvider(this);
        CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);
        descriptor.setPolicy((IApplicationPolicy)signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new DispatchKeystoreAppFactory("decryptor");
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IDecryptor.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    public KeystoreDeviceProvider getDefaultDeviceProvider() {
        return this.defaultDeviceProvider;
    }

    @PostConstruct
    public void init() {
        super.init();
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
        try {
            this.registerDevice((DispatchKeystoreDevice)this.createInstance((IArgs)Args.create()));
            KeystoreDeviceProvider provider = (KeystoreDeviceProvider)DeviceTools.toDeviceProvider(KeystoreDeviceProvider.class);
            this.setDefaultDeviceProvider(provider);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setDefaultDeviceProvider(KeystoreDeviceProvider keystoreDeviceProvider) {
        this.defaultDeviceProvider = keystoreDeviceProvider;
    }
}

