/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.device;

import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.key.CommonKeyStore;
import de.intarsys.security.device.key.DefaultCertifier;
import de.intarsys.security.device.key.DefaultKeyPairGenerator;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.device.key.ReadOnlyKeyStore;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.security.device.keystore.device.KeystorePrincipal;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Iterator;

@FactoredBy(factory=KeystoreDeviceProvider.class)
public class KeystoreDevice
extends CommonDevice<KeystoreDeviceProvider> {
    public static final String LIC_PRODUCT = "de.intarsys.security.device.keystore";
    private static final Attribute ATTR_PRINCIPAL = new Attribute("principal");
    private ICertificateProvider certificateProvider;
    private boolean loaded = false;
    private String rsaEncryptionEncoding;
    private CommonKeyStore principalStore = new ReadOnlyKeyStore();
    private IFactory<IKeyPairGenerator> keyPairGeneratorFactory = new CommonInstantiatingFactory<IKeyPairGenerator>(){

        protected IKeyPairGenerator basicCreateInstance(IArgs args) throws ObjectCreationException {
            return new DefaultKeyPairGenerator();
        }

        public Class<DefaultKeyPairGenerator> getResultType() {
            return DefaultKeyPairGenerator.class;
        }
    };
    private IFactory<IPublicKeyCertifier> certifierFactory = new CommonInstantiatingFactory<IPublicKeyCertifier>(){

        protected IPublicKeyCertifier basicCreateInstance(IArgs args) throws ObjectCreationException {
            return new DefaultCertifier();
        }

        public Class<DefaultCertifier> getResultType() {
            return DefaultCertifier.class;
        }
    };

    protected KeystoreDevice(KeystoreDeviceProvider deviceProvider, String name) {
        super((CommonDeviceProvider)deviceProvider, name);
    }

    public IPrincipal createPrincipal(IX509Certificate certificate) {
        return this.createPrincipal(certificate, true);
    }

    protected KeystorePrincipal createPrincipal(IX509Certificate certificate, boolean owner) {
        KeystorePrincipal principal = (KeystorePrincipal)((Object)certificate.getAttribute((Object)ATTR_PRINCIPAL));
        if (principal == null) {
            if (certificate instanceof IX509PublicKeyCertificate) {
                principal = new KeystorePrincipal((IDevice)this, (IX509PublicKeyCertificate)certificate);
                principal.setKeyOwner(owner);
            }
            certificate.setAttribute((Object)ATTR_PRINCIPAL, (Object)principal);
        }
        return principal;
    }

    protected void ensurePrincipalsAvailable() {
        super.ensurePrincipalsAvailable();
        if (!this.loaded) {
            ArrayList<KeystorePrincipal> principals = new ArrayList<KeystorePrincipal>();
            if (this.getCertificateProvider() != null) {
                X509CertificateSelector filter = new X509CertificateSelector();
                filter.setAcceptAttributeCertificates(false);
                filter.setHasPrivateKey(Boolean.valueOf(true));
                Iterator it = this.getCertificateProvider().lookupCertificates((IX509CertificateFilter)filter);
                while (it.hasNext()) {
                    IX509Certificate certificate = (IX509Certificate)it.next();
                    KeystorePrincipal principal = this.createPrincipal(certificate, true);
                    if (principal == null) continue;
                    principals.add(principal);
                }
            }
            this.loaded = true;
            this.setPrincipals(principals);
        }
    }

    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public IFactory<IPublicKeyCertifier> getCertifierFactory() {
        return this.certifierFactory;
    }

    public IFactory<IKeyPairGenerator> getKeyPairGeneratorFactory() {
        return this.keyPairGeneratorFactory;
    }

    public CommonKeyStore getPrincipalStore() {
        return this.principalStore;
    }

    public String getRsaEncryptionEncoding() {
        return this.rsaEncryptionEncoding;
    }

    public boolean isPrincipalDeleteSupported() {
        return this.getPrincipalStore().isDeleteSupported();
    }

    public boolean isPrincipalStoreSupported() {
        return this.getPrincipalStore().isStoreSupported();
    }

    public void principalDelete(IX509PublicKeyCertificate certificate) throws SecurityApplicationException {
        this.getPrincipalStore().delete(certificate);
        this.loaded = false;
    }

    public void principalStore(IX509PublicKeyCertificate certificate, KeyPair keyPair, Secret password) throws SecurityApplicationException {
        this.getPrincipalStore().store(certificate, keyPair, password);
        this.loaded = false;
    }

    public void setCertificateProvider(ICertificateProvider provider) {
        this.certificateProvider = provider;
        this.loaded = false;
    }

    public void setCertifierFactory(IFactory<IPublicKeyCertifier> certifierFactory) {
        this.certifierFactory = certifierFactory;
    }

    public void setKeyPairGeneratorFactory(IFactory<IKeyPairGenerator> keyPairGeneratorFactory) {
        this.keyPairGeneratorFactory = keyPairGeneratorFactory;
    }

    public void setPrincipalStore(CommonKeyStore principalStore) {
        this.principalStore = principalStore;
    }

    public void setRsaEncryptionEncoding(String rsaEncryptionEncoding) {
        this.rsaEncryptionEncoding = rsaEncryptionEncoding;
    }
}

