/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.device;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.PublicKeyCertificateFilter;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProviderFactoryBean;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.common.CommonDeviceFactoryBean;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.key.CommonKeyStore;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreDeviceFactoryBean
extends CommonDeviceFactoryBean<KeystoreDevice> {
    private static final Logger Log = LoggerFactory.getLogger(KeystoreDeviceFactoryBean.class);
    private IByteProvider keyStoreKeyProvider;
    private String keyStoreFileName;
    private ILocator keyStoreLocator;
    private String keyStoreDirectoryName;
    private Secret keyStorePassword;
    private ICertificateProvider certificateProvider;
    private List<ICertificateProvider> certificateProviders;
    private CommonKeyStore principalStore;
    private IFactory<IKeyPairGenerator> keyPairGeneratorFactory;
    private IFactory<IPublicKeyCertifier> certifierFactory;
    private ICertificateProvider derivedCertificateProvider;
    private CommonKeyStore derivedPrincipalStore;

    protected ICertificateProvider createCertificateProviderFromDirectory() throws Exception {
        String dirName = this.getKeyStoreDirectoryName();
        CompositeCertificateProvider composite = new CompositeCertificateProvider("keystore-dir-" + this.getId());
        Log.info("{}, loading keystores from {}", (Object)this.getLogLabel(), (Object)dirName);
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                ICertificateProvider provider = this.createCertificateProviderFromFile(file.getAbsolutePath());
                composite.registerCertificateProvider(provider);
            }
        }
        return composite;
    }

    protected ICertificateProvider createCertificateProviderFromFile(String fileName) throws Exception {
        Log.info("{}, loading keystore from {}", (Object)this.getLogLabel(), (Object)fileName);
        KeyStoreCertificateProviderFactoryBean factory = new KeyStoreCertificateProviderFactoryBean();
        factory.setKeyStoreFileName(fileName);
        factory.setKeyStoreKeyProvider(this.getKeyStoreKeyProvider());
        factory.setKeyStorePassword(this.getKeyStorePassword());
        factory.afterPropertiesSet();
        KeyStoreCertificateProvider provider = (KeyStoreCertificateProvider)factory.getObject();
        this.logCertificates((ICertificateProvider)provider);
        return provider;
    }

    protected ICertificateProvider createCertificateProviderFromList() {
        CompositeCertificateProvider composite = new CompositeCertificateProvider("keystore-list-" + this.getId());
        for (ICertificateProvider provider : this.getCertificateProviders()) {
            Log.info("{}, assigning certificate provider {}", (Object)this.getLogLabel(), (Object)provider);
            this.logCertificates(provider);
            composite.registerCertificateProvider(provider);
        }
        return composite;
    }

    protected ICertificateProvider createCertificateProviderFromLocator(ILocator locator) throws Exception {
        Log.info("{}, loading keystore from {}", (Object)this.getLogLabel(), (Object)locator);
        KeyStoreCertificateProviderFactoryBean factory = new KeyStoreCertificateProviderFactoryBean();
        factory.setKeyStoreLocator(locator);
        factory.setKeyStoreKeyProvider(this.getKeyStoreKeyProvider());
        factory.setKeyStorePassword(this.getKeyStorePassword());
        factory.afterPropertiesSet();
        KeyStoreCertificateProvider provider = (KeyStoreCertificateProvider)factory.getObject();
        this.logCertificates((ICertificateProvider)provider);
        return provider;
    }

    protected ICertificateProvider createCertificateProviderFromProvider() {
        Log.info("{}, assigning certificate provider {}", (Object)this.getLogLabel(), (Object)this.getCertificateProvider());
        this.logCertificates(this.getCertificateProvider());
        return this.getCertificateProvider();
    }

    protected CommonDeviceProvider createDeviceProvider() {
        return (CommonDeviceProvider)DeviceTools.lookupDeviceProvider(KeystoreDeviceProvider.class);
    }

    protected KeystoreDevice createInstance() throws Exception {
        CommonDeviceProvider deviceProvider = this.getDeviceProviderOrDefault();
        if (deviceProvider == null) {
            throw new ObjectCreationException("cannot create device '" + this.getId() + "', device provider missing");
        }
        this.deriveDeviceProperties();
        Args args = Args.create();
        args.put("id", (Object)this.getId());
        args.put("certificateProvider", (Object)this.derivedCertificateProvider);
        args.put("principalStore", (Object)this.derivedPrincipalStore);
        args.put("keyPairGeneratorFactory", this.getKeyPairGeneratorFactory());
        args.put("certifierFactory", this.getCertifierFactory());
        Log.info("{}, create instance", (Object)this.getLogLabel());
        KeystoreDevice device = (KeystoreDevice)deviceProvider.createInstance((IArgs)args);
        return device;
    }

    protected void deriveDeviceProperties() throws Exception {
        this.derivedCertificateProvider = null;
        if (!StringTools.isEmpty((String)this.getKeyStoreFileName())) {
            this.derivedCertificateProvider = this.createCertificateProviderFromFile(this.getKeyStoreFileName());
        } else if (!StringTools.isEmpty((String)this.getKeyStoreDirectoryName())) {
            this.derivedCertificateProvider = this.createCertificateProviderFromDirectory();
        } else if (this.getKeyStoreLocator() != null) {
            this.derivedCertificateProvider = this.createCertificateProviderFromLocator(this.getKeyStoreLocator());
        } else if (this.getCertificateProvider() != null) {
            this.derivedCertificateProvider = this.createCertificateProviderFromProvider();
        } else if (this.getCertificateProviders() != null && !this.getCertificateProviders().isEmpty()) {
            this.derivedCertificateProvider = this.createCertificateProviderFromList();
        } else {
            throw new IllegalArgumentException("certificate provider information missing");
        }
        if (this.getPrincipalStore() != null) {
            this.derivedPrincipalStore = this.getPrincipalStore();
        }
    }

    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public List<ICertificateProvider> getCertificateProviders() {
        return this.certificateProviders;
    }

    public IFactory<IPublicKeyCertifier> getCertifierFactory() {
        return this.certifierFactory;
    }

    protected ICertificateProvider getDerivedCertificateProvider() {
        return this.derivedCertificateProvider;
    }

    public IFactory<IKeyPairGenerator> getKeyPairGeneratorFactory() {
        return this.keyPairGeneratorFactory;
    }

    public String getKeyStoreDirectoryName() {
        return this.keyStoreDirectoryName;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public IByteProvider getKeyStoreKeyProvider() {
        return this.keyStoreKeyProvider;
    }

    public ILocator getKeyStoreLocator() {
        return this.keyStoreLocator;
    }

    public Secret getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Class<?> getObjectType() {
        return KeystoreDevice.class;
    }

    public CommonKeyStore getPrincipalStore() {
        return this.principalStore;
    }

    protected void logCertificates(ICertificateProvider provider) {
        Iterator itCertificates = provider.lookupCertificates((IX509CertificateFilter)PublicKeyCertificateFilter.UNIQUE);
        while (itCertificates.hasNext()) {
            IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)itCertificates.next();
            Log.info("{}, loaded {}, alias {}", new Object[]{this.getLogLabel(), certificate.getSubjectX500Principal(), certificate.getAlias()});
        }
    }

    public void setCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    public void setCertificateProviders(List<ICertificateProvider> certificateProviders) {
        this.certificateProviders = certificateProviders;
    }

    public void setCertifierFactory(IFactory<IPublicKeyCertifier> certifierFactory) {
        this.certifierFactory = certifierFactory;
    }

    public void setKeyPairGeneratorFactory(IFactory<IKeyPairGenerator> keyPairGeneratorFactory) {
        this.keyPairGeneratorFactory = keyPairGeneratorFactory;
    }

    public void setKeyStoreDirectoryName(String keyStoreDirectoryName) {
        this.keyStoreDirectoryName = keyStoreDirectoryName;
    }

    public void setKeyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
    }

    public void setKeyStoreKeyProvider(IByteProvider keyStoreKeyProvider) {
        this.keyStoreKeyProvider = keyStoreKeyProvider;
    }

    public void setKeyStoreLocator(ILocator keyStoreLocator) {
        this.keyStoreLocator = keyStoreLocator;
    }

    public void setKeyStorePassword(Secret keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setPrincipalStore(CommonKeyStore principalStore) {
        this.principalStore = principalStore;
    }
}

