/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.device;

import de.intarsys.security.app.IApplicationDescriptor;
import de.intarsys.security.app.IApplicationPolicy;
import de.intarsys.security.app.NoPolicy;
import de.intarsys.security.app.authentication.IAuthenticator;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.app.encryption.IEncryptor;
import de.intarsys.security.app.principal.IPrincipalAdministration;
import de.intarsys.security.app.signature.CommonSignerPolicy;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.creation.IKeyPairGenerator;
import de.intarsys.security.certificate.provider.CertificateProviderTools;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.key.CommonKeyStore;
import de.intarsys.security.device.key.IPublicKeyCertifier;
import de.intarsys.security.device.keystore.app.authentication.KeyStoreAuthenticatorFactory;
import de.intarsys.security.device.keystore.app.decryption.KeyStoreDecryptorFactory;
import de.intarsys.security.device.keystore.app.encryption.KeyStoreEncryptorFactory;
import de.intarsys.security.device.keystore.app.principals.KeystorePrincipalAdministrationFactory;
import de.intarsys.security.device.keystore.app.signature.KeyStoreSignerFactory;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicensePropertyUnit;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.List;

public class KeystoreDeviceProvider
extends CommonDeviceProvider<KeystoreDevice> {
    private final CommonSignerPolicy signerPolicy = new CommonSignerPolicy((CommonDeviceProvider)this);

    public KeystoreDeviceProvider() {
        super("keystore");
    }

    protected KeystoreDevice basicCreateInstance(IArgs args) throws ObjectCreationException {
        IFactory certifierFactory;
        IFactory keyPairGeneratorFactory;
        KeystoreDevice device = new KeystoreDevice(this, this.getId(args));
        Object objectProvider = ArgTools.getObject((IArgs)args, (String)"certificateProvider", null);
        device.setCertificateProvider(CertificateProviderTools.createCertificateProvider((Object)objectProvider));
        CommonKeyStore principalStore = (CommonKeyStore)ArgTools.getObject((IArgs)args, (String)"principalStore", null);
        if (principalStore != null) {
            device.setPrincipalStore(principalStore);
        }
        if ((keyPairGeneratorFactory = (IFactory)ArgTools.getObject((IArgs)args, (String)"keyPairGeneratorFactory", null)) != null) {
            device.setKeyPairGeneratorFactory((IFactory<IKeyPairGenerator>)keyPairGeneratorFactory);
        }
        if ((certifierFactory = (IFactory)ArgTools.getObject((IArgs)args, (String)"certifierFactory", null)) != null) {
            device.setCertifierFactory((IFactory<IPublicKeyCertifier>)certifierFactory);
        }
        return device;
    }

    protected void configureDevice(IElement elDevice) throws ConfigurationException {
        try {
            Args args = Args.create();
            String idString = elDevice.attributeValue("id", null);
            if (idString == null) {
                throw new ObjectCreationException("'id' required");
            }
            args.put("id", (Object)idString);
            this.registerDevice((KeystoreDevice)this.createInstance((IArgs)args));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected void declareApplicationDescriptors(List<IApplicationDescriptor> apps) {
        super.declareApplicationDescriptors(apps);
        Object descriptor = new KeyStoreSignerFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setLicenseAccountSupplier(() -> this.declareLicenseAccountSign());
        descriptor.setPolicy((IApplicationPolicy)this.signerPolicy);
        descriptor.setType(ISigner.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new KeyStoreAuthenticatorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IAuthenticator.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new KeyStoreEncryptorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IEncryptor.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new KeyStoreDecryptorFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IDecryptor.class);
        apps.add((IApplicationDescriptor)descriptor);
        descriptor = new KeystorePrincipalAdministrationFactory();
        descriptor.setDeviceProvider(this);
        descriptor.setPolicy((IApplicationPolicy)new NoPolicy((CommonDeviceProvider)this));
        descriptor.setType(IPrincipalAdministration.class);
        apps.add((IApplicationDescriptor)descriptor);
    }

    protected ILicenseAccount declareLicenseAccountSignBasic() {
        ILicenseAccount account = this.getLicenseProduct().getAccount("de.intarsys.security.app.sign.account");
        account.setDefaultValueUnit(10, LicensePropertyUnit.PER_MINUTE);
        return account;
    }

    protected LicenseProduct declareLicenseProduct() {
        return LicenseTools.createProduct((Object)((Object)this), (String)"de.intarsys.security.device.keystore");
    }

    @PostConstruct
    public void init() {
        super.init();
        IElement policyElement = ElementTools.getPathElement((IElement)this.getConfiguration(), (String[])new String[]{"policies", "signer"});
        if (policyElement != null) {
            try {
                this.signerPolicy.configure(policyElement);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        DeviceProviderRegistry.get().registerDeviceProvider((IDeviceProvider)this);
    }
}

