/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.keystore.processor;

import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderSupport;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.certificate.provider.standard.PreselectCertificateProvider;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.keystore.device.DispatchKeystoreDeviceProvider;
import de.intarsys.security.device.processor.CommonDecryptorFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeyStoreDecryptorFactory
extends CommonDecryptorFactory
implements ICertificateProviderSupport {
    public static final String ID = KeyStoreDecryptorFactory.class.getName();

    protected Object basicCreateInstance(IArgs args) throws ObjectCreationException {
        IDevice device = DeviceTools.getDefaultDevice(DispatchKeystoreDeviceProvider.class);
        IDecryptor app = (IDecryptor)device.createApplication(IDecryptor.class.getName(), args);
        return app;
    }

    public ICertificateProvider getCertificateProvider() {
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setPrivateKeyAccessible(Boolean.valueOf(true));
        selector.setSecurityApplication("decryption");
        return new PreselectCertificateProvider((IX509CertificateFilter)selector, IdCertificateProvider.get());
    }
}

