/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.keystore;

import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.device.pool.device.PoolDeviceFactoryBean;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.IPoolListener;
import de.intarsys.security.device.pool.keystore.KeystorePoolListener;
import de.intarsys.security.device.pool.keystore.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;

public class KeystorePoolDeviceFactoryBean
extends PoolDeviceFactoryBean {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Object certificateFilter;
    private int maxThreadsPerDevice = -1;

    public KeystorePoolDeviceFactoryBean() {
        this.setTypeDescription(Msg.getString("KeystorePoolDeviceFactoryBean.typeDescription", new Object[0]));
    }

    protected IPoolListener createPoolListener(GenericPool pool) throws ObjectCreationException {
        KeystorePoolListener listener = new KeystorePoolListener(pool);
        listener.setMaxThreadsPerDevice(this.getMaxThreadsPerDevice());
        listener.setCertificateFilter(CertificateFilterTools.createCertificateFilter((Object)this.getCertificateFilter()));
        return listener;
    }

    public Object getCertificateFilter() {
        return this.certificateFilter;
    }

    public int getMaxThreadsPerDevice() {
        return this.maxThreadsPerDevice;
    }

    public void setCertificateFilter(Object certificateFilter) {
        this.certificateFilter = certificateFilter;
    }

    public void setMaxThreadsPerDevice(int maxThreadsPerDevice) {
        this.maxThreadsPerDevice = maxThreadsPerDevice;
    }
}

