/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.pool.keystore;

import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.ISecurityApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.standard.IdCertificateProvider;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.keystore.device.DispatchKeystoreDeviceProvider;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.pool.impl.AcceptException;
import de.intarsys.security.device.pool.impl.CommonPoolListener;
import de.intarsys.security.device.pool.impl.GenericPool;
import de.intarsys.security.device.pool.impl.PoolEntry;
import de.intarsys.security.device.pool.keystore.PACKAGE;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.IElementSerializationHandler;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reporter.Reporter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KeystorePoolListener<T extends ISecurityApplication>
extends CommonPoolListener<T> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(KeystorePoolListener.class);
    private IX509CertificateFilter certificateFilter;
    private ICertificateProvider certificateProvider;
    private KeystoreDevice keystoreDevice;
    private int maxThreadsPerDevice = -1;

    public KeystorePoolListener(GenericPool<T> pool) {
        super(pool);
    }

    public void authenticate(GenericPool<T> pool, PoolEntry<T> entry) throws AcceptException, SecurityApplicationException {
        ISecurityApplication signer = entry.getSecurityApplication();
        if (signer instanceof IAuthenticatedApplication) {
            IAuthenticatedApplication authApp = (IAuthenticatedApplication)signer;
            if (this.getPasswordProvider() != null) {
                authApp.setPasswordProvider(this.getPasswordProvider());
            }
            if (!CryptoTools.isEmpty((Secret)this.getPin())) {
                authApp.setAuthenticationPin(this.getPin());
            }
            String tmpPrompt = Msg.getString("KeystorePoolPolicy.authenticationMessage", new Object[0]);
            authApp.setAuthenticationPrompt(tmpPrompt);
            try {
                authApp.authenticate().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SecurityApplicationException("execution interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
            }
        }
    }

    protected void basicRefreshEntries() throws Exception {
        Collection<CertificateHolder> signerCerts;
        try {
            signerCerts = this.lookupSignerCertificates();
        }
        catch (IOException e) {
            return;
        }
        for (PoolEntry entry : this.getPool().getEntries()) {
            if (signerCerts.contains(this.getSignerCertificate(entry.getSecurityApplication()))) continue;
            this.getPool().destroy(entry);
        }
        for (CertificateHolder signerCert : signerCerts) {
            PoolEntry<T> entry = this.lookupEntry(signerCert);
            if (entry != null) continue;
            try {
                this.openApplication(signerCert);
            }
            catch (AcceptException e) {
                Log.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            IElement certificateFilterElement = element.element("certificateFilter");
            if (certificateFilterElement != null) {
                this.setCertificateFilter((IX509CertificateFilter)ElementTools.createObject((IElement)certificateFilterElement, IX509CertificateFilter.class, (Object)this.getContext(), (IArgs)Args.create()));
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.setMaxThreadsPerDevice(ElementTools.getInt((IElement)element, (String)"maxThreadsPerDevice", (int)-1));
    }

    protected Class<ISigner> getApplicationType() {
        return ISigner.class;
    }

    public IX509CertificateFilter getCertificateFilter() {
        return this.certificateFilter;
    }

    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    public Object getContext() {
        return null;
    }

    public KeystoreDevice getKeystoreDevice() {
        return this.keystoreDevice;
    }

    protected Object getLogLabel() {
        return ((Object)((Object)this)).toString();
    }

    public int getMaxThreadsPerDevice() {
        return this.maxThreadsPerDevice;
    }

    protected CertificateHolder getSignerCertificate(T signer) {
        IX509PublicKeyCertificate[] certificatePath = ((ISigner)signer).getCertificatePath();
        if (certificatePath.length == 0) {
            return null;
        }
        return new CertificateHolder((IX509Certificate)certificatePath[0]);
    }

    protected void housekeeping() {
    }

    protected PoolEntry<T> lookupEntry(CertificateHolder signerCertificate) {
        for (PoolEntry entry : this.getPool().getEntries()) {
            if (!this.getSignerCertificate(entry.getSecurityApplication()).equals(signerCertificate)) continue;
            return entry;
        }
        return null;
    }

    protected Collection<CertificateHolder> lookupSignerCertificates() throws IOException {
        if (this.getCertificateFilter() == null) {
            Log.warn("{} certificate filter is undefined", this.getLogLabel());
            return Collections.emptyList();
        }
        ICertificateProvider tmpProvider = this.getCertificateProvider();
        if (tmpProvider == null) {
            ICertificateProvider iCertificateProvider = tmpProvider = this.getKeystoreDevice() == null ? null : this.getKeystoreDevice().getCertificateProvider();
        }
        if (tmpProvider == null) {
            tmpProvider = IdCertificateProvider.get();
        }
        Iterator certIter = tmpProvider.lookupCertificates(this.getCertificateFilter());
        HashSet<CertificateHolder> result = new HashSet<CertificateHolder>();
        while (certIter.hasNext()) {
            result.add(new CertificateHolder((IX509Certificate)certIter.next()));
        }
        return result;
    }

    public void onStartAfter(GenericPool pool) {
        try {
            this.openApplications();
        }
        catch (AcceptException e) {
            Log.warn(e.getLocalizedMessage(), (Throwable)e);
            Reporter.get().reportError(Msg.getString("KeystorePoolPolicy.report.title", new Object[0]), e.getLocalizedMessage(), (Throwable)e, 0);
        }
    }

    public void onStartBefore(GenericPool pool) {
    }

    public void onStopAfter(GenericPool<T> pool) {
    }

    public void onStopBefore(GenericPool<T> pool) {
    }

    protected void openApplication(CertificateHolder signerCertificate) throws AcceptException {
        ISecurityApplication app = null;
        try {
            IX509CertificateFilter signerSelector = CertificateFilterTools.createCertificateFilter((Object)signerCertificate.getCertificate());
            Args args = Args.create();
            args.put("signerIdentifier", (Object)signerSelector);
            KeystoreDevice device = this.getKeystoreDevice();
            if (device == null) {
                device = DeviceTools.getDefaultDevice(DispatchKeystoreDeviceProvider.class);
            }
            app = (ISecurityApplication)device.createApplication(ISigner.class.getName(), (IArgs)args);
            String subjectName = CertificateTools.getSubjectLabel((IX509Certificate)signerCertificate.getCertificate());
            String label = Msg.getString("KeystorePoolPolicy.certificateLabel", new Object[]{this.getPool().getLabel(), subjectName});
            this.getPool().addApplication(app, label);
        }
        catch (AcceptException e) {
            if (app != null) {
                app.dispose();
            }
            throw e;
        }
        catch (Exception e) {
            if (app != null) {
                app.dispose();
            }
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.debug(this + " can't open application");
            }
            String msg = Msg.getString("KeystorePoolPolicy.ErrorAcceptCantOpenApplication", new Object[]{this.getPool().getLabel()});
            throw new AcceptException(msg, (Throwable)e);
        }
    }

    protected void openApplications() throws AcceptException {
        Collection<CertificateHolder> signerCerts;
        try {
            signerCerts = this.lookupSignerCertificates();
        }
        catch (IOException e) {
            throw new AcceptException("invalid certificate");
        }
        if (signerCerts == null || signerCerts.isEmpty()) {
            throw new AcceptException("no signer certificates found");
        }
        for (CertificateHolder signerCert : signerCerts) {
            this.openApplication(signerCert);
        }
    }

    public void preferencesRestore(IPreferences prefs) {
        super.preferencesRestore(prefs);
        try {
            String tmpString = prefs.get("certificateFilter");
            IX509CertificateFilter tempFilter = CertificateFilterTools.createCertificateFilter((Object)tmpString);
            if (tempFilter != null) {
                this.setCertificateFilter(tempFilter);
            }
        }
        catch (ObjectCreationException e) {
            Log.warn("{} failed to restore preferences ", (Object)this, (Object)e);
        }
    }

    public void preferencesStore(IPreferences prefs) {
        super.preferencesStore(prefs);
        try {
            if (this.getCertificateFilter() instanceof IElementSerializable) {
                IElement element = ElementFactory.get().createElement("certificateFilter");
                ((IElementSerializable)this.getCertificateFilter()).serialize(element);
                prefs.put("certificateFilter", element.asXML());
            }
        }
        catch (ElementSerializationException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    public void refresh() {
        try {
            this.basicRefreshEntries();
        }
        catch (Exception e) {
            Log.error("error refreshing pool");
        }
    }

    public void serialize(IElement element) throws ElementSerializationException {
        IX509CertificateFilter target = this.getCertificateFilter();
        if (target != null) {
            IFactory factory;
            IElement tempElement = element.newElementMapped("certificateFilter");
            if (target instanceof IElementSerializable) {
                ((IElementSerializable)target).serialize(tempElement);
            } else if (target instanceof IFactorySupport && (factory = ((IFactorySupport)target).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)target, tempElement);
            }
        }
        element.setAttributeValue("maxThreadsPerDevice", String.valueOf(this.getMaxThreadsPerDevice()));
    }

    public void setCertificateFilter(IX509CertificateFilter filter) {
        this.certificateFilter = filter;
    }

    public void setCertificateProvider(ICertificateProvider certificateProvider) {
        this.certificateProvider = certificateProvider;
    }

    public void setKeystoreDevice(KeystoreDevice keystoreDevice) {
        this.keystoreDevice = keystoreDevice;
    }

    public void setMaxThreadsPerDevice(int maxThreadsPerDevice) {
        this.maxThreadsPerDevice = maxThreadsPerDevice;
    }

    static class CertificateHolder {
        private final IX509Certificate certificate;

        public CertificateHolder(IX509Certificate certificate) {
            this.certificate = certificate;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CertificateHolder)) {
                return false;
            }
            CertificateHolder otherHolder = (CertificateHolder)other;
            if (this.getCertificate().getCertificateProvider() != otherHolder.getCertificate().getCertificateProvider()) {
                return false;
            }
            return LangTools.equals((Object)this.getCertificate(), (Object)otherHolder.getCertificate());
        }

        public IX509Certificate getCertificate() {
            return this.certificate;
        }

        protected String getKey() {
            ICertificateProvider certificateProvider = this.getCertificate().getCertificateProvider();
            String key = String.valueOf(certificateProvider == null ? "" : Integer.valueOf(certificateProvider.hashCode()));
            return key + "/" + this.getCertificate().hashCode();
        }

        public String getLabel() {
            return CertificateTools.getSubjectLabel((IX509Certificate)this.getCertificate());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public String toString() {
            return this.getKey();
        }
    }
}

