/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.keystore.environment;

import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;

@SingletonProvider
public class KeystoreEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final String PREF_SIGNATURE_HASH_ALGORITHM = "signatureHashAlgorithm";
    private String signatureHashAlgorithm;
    private IPreferences preferences;

    public static KeystoreEnvironment get() {
        return (KeystoreEnvironment)ServiceLocator.get().get(KeystoreEnvironment.class);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.keystore";
    }

    public String getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_SIGNATURE_HASH_ALGORITHM, "SHA-512");
    }

    public void preferencesRestore() {
        IPreferences prefs = this.getPreferences();
        this.setSignatureHashAlgorithm(prefs.get(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm()));
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        preferences.put(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm());
    }

    public void setSignatureHashAlgorithm(String signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }
}

