/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.device;

import de.intarsys.cloudsuite.gears.core.manage.device.DeviceProviderHealthIndicator;
import de.intarsys.security.device.DeviceProviderRegistry;
import de.intarsys.security.device.IDeviceProvider;
import java.util.Iterator;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.health.NamedContributor;

public class DeviceHealthContributor
implements CompositeHealthContributor {
    protected HealthContributor adapt(IDeviceProvider value) {
        return new DeviceProviderHealthIndicator(value);
    }

    public HealthContributor getContributor(String name) {
        for (IDeviceProvider deviceProvider : DeviceProviderRegistry.get().getDeviceProviders()) {
            if (!deviceProvider.getId().equals(name)) continue;
            return this.adapt(deviceProvider);
        }
        return null;
    }

    public Iterator<NamedContributor<HealthContributor>> iterator() {
        final Iterator iterator = DeviceProviderRegistry.get().getDeviceProviders().iterator();
        return new Iterator<NamedContributor<HealthContributor>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public NamedContributor<HealthContributor> next() {
                IDeviceProvider entry = (IDeviceProvider)iterator.next();
                return NamedContributor.of((String)entry.getId(), (Object)DeviceHealthContributor.this.adapt(entry));
            }
        };
    }
}

