/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.device;

import de.intarsys.cloudsuite.gears.core.manage.common.CommonHealthIndicator;
import de.intarsys.manage.health.IHealthObject;
import de.intarsys.manage.health.IHealthSupport;
import de.intarsys.security.device.IDevice;
import java.util.HashMap;
import org.springframework.boot.actuate.health.Health;

public class DeviceHealthIndicator
extends CommonHealthIndicator {
    private final IDevice device;

    public DeviceHealthIndicator(IDevice device) {
        this.device = device;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.device instanceof IHealthSupport) {
            IHealthObject health = ((IHealthSupport)this.device).getHealth();
            builder.withDetails(this.toMap(health));
            builder.status(health.computeStatus());
        } else {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("id", this.device.getId());
            details.put("type", this.device.getClass().getName());
            builder.withDetails(details);
            builder.up();
        }
    }
}

