/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.device;

import de.intarsys.cloudsuite.gears.core.manage.common.CommonHealthIndicator;
import de.intarsys.cloudsuite.gears.core.manage.device.DeviceHealthIndicator;
import de.intarsys.manage.health.IHealthObject;
import de.intarsys.manage.health.IHealthSupport;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IDeviceProvider;
import java.util.HashMap;
import java.util.Iterator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class DeviceProviderHealthIndicator
extends CommonHealthIndicator {
    private final IDeviceProvider deviceProvider;

    public DeviceProviderHealthIndicator(IDeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Status status = Status.UP;
        Iterator itDevices = this.deviceProvider.listDevices(null);
        HashMap<String, Health> devices = new HashMap<String, Health>();
        while (itDevices.hasNext()) {
            IDevice device = (IDevice)itDevices.next();
            Health deviceHealth = new DeviceHealthIndicator(device).health();
            devices.put(device.getId(), deviceHealth);
            if (!Status.DOWN.equals((Object)deviceHealth.getStatus())) continue;
            status = Status.DOWN;
        }
        builder.withDetail("devices", devices);
        if (this.deviceProvider instanceof IHealthSupport) {
            IHealthObject health = ((IHealthSupport)this.deviceProvider).getHealth();
            builder.withDetails(this.toMap(health));
            Status providerStatus = new Status(health.computeStatus());
            if (Status.DOWN.equals((Object)providerStatus)) {
                status = Status.DOWN;
            }
        } else {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("id", this.deviceProvider.getId());
            details.put("type", this.deviceProvider.getClass().getName());
            builder.withDetails(details);
        }
        builder.status(status);
    }
}

