/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.license;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.cloudsuite.gears.core.manage.license.DtoLicenseProperty;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DtoLicense {
    private final License license;

    public DtoLicense(License license) {
        this.license = license;
    }

    public String getOwner() {
        return this.license.getOwnerKey();
    }

    public String getProductId() {
        return this.license.getProductId();
    }

    public String getProductVersion() {
        return this.license.getProductVersion();
    }

    public List<DtoLicenseProperty> getProperties() {
        Iterator it = this.license.getProperties();
        ArrayList<DtoLicenseProperty> result = new ArrayList<DtoLicenseProperty>();
        while (it.hasNext()) {
            result.add(new DtoLicenseProperty((LicenseProperty)it.next()));
        }
        return result;
    }

    @JsonIgnore
    public String getStatusCode() {
        return this.license.isValidPeriod() ? "UP" : "DOWN";
    }

    public String getValidFrom() {
        return this.license.getValidFromString();
    }

    public String getValidTo() {
        return this.license.getValidToString();
    }

    public boolean isValid() {
        return this.license.isValidPeriod();
    }
}

