/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.license;

import de.intarsys.tools.license.ILicenseAccount;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class DtoLicenseAccount {
    private final ILicenseAccount account;

    public DtoLicenseAccount(ILicenseAccount account) {
        this.account = account;
    }

    public int getBalance() {
        return this.account.getBalance();
    }

    public String getLabel() {
        return this.account.getLabel();
    }

    public int getLimit() {
        return this.account.getLimit();
    }

    public String getNextReset() {
        return this.account.getNextReset() == null ? null : DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(this.account.getNextReset());
    }

    public String getProduct() {
        return this.account.getLicenseProduct().getId();
    }

    public String getProperty() {
        return this.account.getName();
    }

    public String getUnit() {
        return this.account.getLicenseProperty().getUnit().getId();
    }
}

