/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.license;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.cloudsuite.gears.core.manage.license.DtoLicense;
import de.intarsys.cloudsuite.gears.core.manage.license.DtoLicenseAccount;
import de.intarsys.tools.license.EnumLicenseState;
import de.intarsys.tools.license.ILicenseAccount;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProduct;
import java.util.List;

public class DtoLicenseProduct {
    private final LicenseProduct product;
    private final EnumLicenseState state;

    public DtoLicenseProduct(LicenseProduct product) {
        this.product = product;
        this.state = LicenseEnvironment.get().getLicenseProductState(product);
    }

    public List<DtoLicenseAccount> getAccounts() {
        return this.product.getAccounts().stream().map(account -> new DtoLicenseAccount((ILicenseAccount)account)).toList();
    }

    public String getId() {
        return this.product.getId();
    }

    public String getLabel() {
        return this.product.getLabel();
    }

    public List<DtoLicense> getLicenses() {
        return LicenseEnvironment.get().getLicenses(this.product).stream().map(license -> new DtoLicense((License)license)).toList();
    }

    public String getState() {
        return this.state.getId();
    }

    @JsonIgnore
    public String getStatusCode() {
        return this.state.isValid() ? "UP" : "DOWN";
    }

    public String getVersion() {
        return this.product.getVersion();
    }

    public boolean isMain() {
        return this.product.isMain();
    }
}

