/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.manage.license;

import de.intarsys.cloudsuite.gears.core.manage.common.CommonHealthIndicator;
import de.intarsys.cloudsuite.gears.core.manage.license.DtoLicenseProduct;
import de.intarsys.cloudsuite.gears.core.manage.license.LicenseHealthIndicator;
import de.intarsys.cloudsuite.gears.core.manage.license.LicenseProductHealthIndicator;
import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseProduct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.actuate.health.Health;

public class LicensingHealthIndicator
extends CommonHealthIndicator {
    protected Object createLicenses() {
        ArrayList<Health> result = new ArrayList<Health>();
        List licenses = LicenseEnvironment.get().getLicenses();
        for (License license : licenses) {
            result.add(new LicenseHealthIndicator(license).health());
        }
        return result;
    }

    protected Object createProducts() {
        ArrayList<Health> result = new ArrayList<Health>();
        List products = LicenseEnvironment.get().getLicenseProducts();
        for (LicenseProduct product : products) {
            result.add(new LicenseProductHealthIndicator(product).health());
        }
        return result;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("licenses", this.createLicenses());
        details.put("products", this.createProducts());
        builder.withDetails(details);
        LicenseProduct product = LicenseEnvironment.get().getLicenseProduct();
        DtoLicenseProduct dto = new DtoLicenseProduct(product);
        builder.status(dto.getStatusCode());
    }
}

